#ifndef RXFUNCTIONS_H
#define RXFUNCTIONS_H

#include <QThread>
#include "qsstvdefs.h"
#include "sstv/syncprocessor.h"
#include "utils/buffermanag.h"
#include "drmrx/drmdefs.h"
#include "drmrx/drmdatainput.h"
#include "drmrx/sourcedecoder.h"


class filter;
class downsampleFilter;
class modeBase;
class demodulator;


class rxFunctions : public QThread
{
  Q_OBJECT
public:
  enum erxState {RXIDLE,RXRUNNING,RXINIT};
  enum eSSTVState {HUNTING,SLANTADJUST,PROCESSING,RESTART,SYNCLOST,END,WAIT};
  explicit rxFunctions(QObject *parent = 0);
  ~rxFunctions();
  void init();
  void run();
  void stopAndWait();
  void retraceVertical(void);
  void startRX();
  QString getModeString (void){ return lastUsedMode;}
  bool saveOK();
#ifndef QT_NO_DEBUG
  unsigned int setOffset(unsigned int offset, bool ask);
#endif
signals:
  
public slots:

private:
  downsampleFilter *downSampleFilter;
  filter *rxFilter;
  filter *syncFilter;
  unsigned int sampleCounter;
  void setFilters(int index);
  void setState(eSSTVState st);
  void getData();
  void processSSTV();
  bool create(esstvMode m,DSPFLOAT clock);

  void runDRM();

  unsigned int bufferCounter;
  syncProcessor syncProc;
  erxState rxState;
  eSSTVState SSTVState;
  modeBase *currentMode;
  bool abort;
  QString lastUsedMode;
  unsigned long syncPosition;
  buffer<DSPFLOAT,22> rxHoldingBuffer;  // 2^22= 4194304, divided by samplingrate 12000 gives 349 seconds buffering
  buffer<int,22> demodBuffer;  // 2^22= 4194304, divided by samplingrate 12000 gives 349 seconds buffering
  unsigned int xOffset;
  // DRM
  float rRation;
  float resamp_signal[2 * DRMBUFSIZE];
  int n,im;
  drmDataInput *dataInputPtr;
  short int tempBuf[SAMPLINGSTRIPE];

};

#endif // RXFUNCTIONS_H
