//*****************************************************************************
//                              DlgNgsCfgOPT.cpp                              *
//                             ------------------                             *
//  Started     : 03/03/2006                                                  *
//  Last Update : 04/03/2011                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "ngspice/dialogs/DlgNgsCfgOPT.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( DlgNgsCfgOPT, wxDialog )

  EVT_BUTTON( ID_BTN_OK,       DlgNgsCfgOPT::OnBtnOk       )
  EVT_BUTTON( ID_BTN_DEFAULTS, DlgNgsCfgOPT::OnBtnDefaults )
  EVT_BUTTON( ID_BTN_CANCEL,   DlgNgsCfgOPT::OnBtnCancel   )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argument List :
//   poWin - A pointer to the dialog parent window

DlgNgsCfgOPT::DlgNgsCfgOPT( wxWindow * poWin ) :
                wxDialog( poWin, -1, wxT(""), wxDefaultPosition, wxDefaultSize,
                          wxDEFAULT_DIALOG_STYLE, wxDialogNameStr )
{
  SetTitle( wxT(" NG-Spice OPTIONS Line Setup") );
  Initialize( );
  bClear( );
}

//*****************************************************************************
// Destructor.

DlgNgsCfgOPT::~DlgNgsCfgOPT( )
{
}

//*****************************************************************************
// Initialize object attributes.

void  DlgNgsCfgOPT::Initialize( void )
{
  // Call all the initialization functions
  Create( );
  ToolTips( );

  // Layout the of the display objects
  DoLayout( );
}

//*****************************************************************************
// Create the display objects.

void  DlgNgsCfgOPT::Create( void )
{
  wxPanel * poPnlLHS, * poPnlRHS, * poPnlRHS_Opts, * poPnlBtns;
  wxPanel * poPnl1;

  // Create the necessary panel objects
  poPnlLHS      = new wxPanel( this );
  poPnlRHS      = new wxPanel( this );
  poPnlRHS_Opts = new wxPanel( poPnlRHS );
  poPnlBtns     = new wxPanel( poPnlRHS );

  // Create the PnlValue controls
  m_oPnlABSTOL.bCreate( poPnlLHS,      ID_PNL_ABSTOL, 75 );
  m_oPnlCHGTOL.bCreate( poPnlLHS,      ID_PNL_CHGTOL, 75 );
  m_oPnlDEFAD .bCreate( poPnlLHS,      ID_PNL_DEFAD,  75 );
  m_oPnlDEFAS .bCreate( poPnlLHS,      ID_PNL_DEFAS,  75 );
  m_oPnlDEFL  .bCreate( poPnlLHS,      ID_PNL_DEFL,   75 );
  m_oPnlDEFW  .bCreate( poPnlLHS,      ID_PNL_DEFW,   75 );
  m_oPnlGMIN  .bCreate( poPnlLHS,      ID_PNL_GMIN,   75 );
  m_oPnlITL1  .bCreate( poPnlLHS,      ID_PNL_ITL1,   75 );
  m_oPnlITL2  .bCreate( poPnlLHS,      ID_PNL_ITL2,   75 );
  m_oPnlITL4  .bCreate( poPnlLHS,      ID_PNL_ITL4,   75 );
  m_oPnlPIVREL.bCreate( poPnlLHS,      ID_PNL_PIVREL, 75 );
  m_oPnlPIVTOL.bCreate( poPnlRHS_Opts, ID_PNL_PIVTOL, 75 );
  m_oPnlRELTOL.bCreate( poPnlRHS_Opts, ID_PNL_RELTOL, 75 );
  m_oPnlTEMP  .bCreate( poPnlRHS_Opts, ID_PNL_TEMP,   75 );
  m_oPnlTNOM  .bCreate( poPnlRHS_Opts, ID_PNL_TNOM,   75 );
  m_oPnlTRTOL .bCreate( poPnlRHS_Opts, ID_PNL_TRTOL,  75 );
  m_oPnlVNTOL .bCreate( poPnlRHS_Opts, ID_PNL_VNTOL,  75 );

  m_oPnlABSTOL.bSetName( wxT("ABSTOL") );
  m_oPnlCHGTOL.bSetName( wxT("CHGTOL") );
  m_oPnlDEFAD .bSetName( wxT("DEFAD")  );
  m_oPnlDEFAS .bSetName( wxT("DEFAS")  );
  m_oPnlDEFL  .bSetName( wxT("DEFL")   );
  m_oPnlDEFW  .bSetName( wxT("DEFW")   );
  m_oPnlGMIN  .bSetName( wxT("GMIN")   );
  m_oPnlITL1  .bSetName( wxT("ITL1")   );
  m_oPnlITL2  .bSetName( wxT("ITL2")   );
  m_oPnlITL4  .bSetName( wxT("ITL4")   );
  m_oPnlPIVREL.bSetName( wxT("PIVREL") );
  m_oPnlPIVTOL.bSetName( wxT("PIVTOL") );
  m_oPnlRELTOL.bSetName( wxT("RELTOL") );
  m_oPnlTEMP  .bSetName( wxT("TEMP")   );
  m_oPnlTNOM  .bSetName( wxT("TNOM")   );
  m_oPnlTRTOL .bSetName( wxT("TRTOL")  );
  m_oPnlVNTOL .bSetName( wxT("VNTOL")  );

  m_oPnlTEMP  .bSetUnitsType( eUNITS_TEMP );
  m_oPnlTNOM  .bSetUnitsType( eUNITS_TEMP );
  m_oPnlVNTOL .bSetUnitsType( eUNITS_VOLT );

  m_oPnlABSTOL.bSetVarType( eVAR_SCI );
  m_oPnlCHGTOL.bSetVarType( eVAR_SCI );
  m_oPnlDEFAD .bSetVarType( eVAR_SCI );
  m_oPnlDEFAS .bSetVarType( eVAR_SCI );
  m_oPnlDEFL  .bSetVarType( eVAR_SCI );
  m_oPnlDEFW  .bSetVarType( eVAR_SCI );
  m_oPnlGMIN  .bSetVarType( eVAR_SCI );
  m_oPnlITL1  .bSetVarType( eVAR_INT );
  m_oPnlITL2  .bSetVarType( eVAR_INT );
  m_oPnlITL4  .bSetVarType( eVAR_INT );
  m_oPnlPIVTOL.bSetVarType( eVAR_SCI );

  m_oPnlABSTOL.bShowUnits( FALSE );
  m_oPnlCHGTOL.bShowUnits( FALSE );
  m_oPnlDEFAD .bShowUnits( FALSE );
  m_oPnlDEFAS .bShowUnits( FALSE );
  m_oPnlDEFL  .bShowUnits( FALSE );
  m_oPnlDEFW  .bShowUnits( FALSE );
  m_oPnlGMIN  .bShowUnits( FALSE );
  m_oPnlITL1  .bShowUnits( FALSE );
  m_oPnlITL2  .bShowUnits( FALSE );
  m_oPnlITL4  .bShowUnits( FALSE );
  m_oPnlPIVREL.bShowUnits( FALSE );
  m_oPnlPIVTOL.bShowUnits( FALSE );
  m_oPnlRELTOL.bShowUnits( FALSE );
  m_oPnlTRTOL .bShowUnits( FALSE );

  m_oPnlABSTOL.bSetParms( NGS_ABSTOL, 1.00E-14, 9.99E-10 );
  m_oPnlCHGTOL.bSetParms( NGS_CHGTOL, 1.00E-15, 9.99E-09 );
  m_oPnlDEFAD .bSetParms( NGS_DEFAD,  1.00E-14, 9.99E-10 );
  m_oPnlDEFAS .bSetParms( NGS_DEFAS,  1.00E-14, 9.99E-10 );
  m_oPnlDEFL  .bSetParms( NGS_DEFL,   1.00E-08, 9.99E-02 );
  m_oPnlDEFW  .bSetParms( NGS_DEFW,   1.00E-08, 9.99E-02 );
  m_oPnlGMIN  .bSetParms( NGS_GMIN,   1.00E-14, 9.99E-10 );
  m_oPnlPIVTOL.bSetParms( NGS_PIVTOL, 1.00E-15, 9.99E-11 );

  m_oPnlTRTOL .bSetParms(         NGS_TRTOL,  0.01,  100.0, 0.01,  10.0 );
  m_oPnlVNTOL .bSetParms(         NGS_VNTOL,  0.00, 1000.0, 0.01, 100.0 );
  m_oPnlPIVREL.bSetParms( 100.0 * NGS_PIVREL, 0.01,  100.0, 0.01,  10.0 );
  m_oPnlRELTOL.bSetParms( 100.0 * NGS_RELTOL, 0.01,  100.0, 0.01,  10.0 );

  m_oPnlITL1  .bSetParms( NGS_ITL1, 0, 1000, 1, 10 );
  m_oPnlITL2  .bSetParms( NGS_ITL2, 0, 1000, 1, 10 );
  m_oPnlITL4  .bSetParms( NGS_ITL4, 0, 1000, 1, 10 );

  m_oPnlABSTOL.bSetUnits( wxT("Amp")       );
  m_oPnlDEFAD .bSetUnits( wxT("Sq. Meter") );
  m_oPnlDEFAS .bSetUnits( wxT("Sq. Meter") );
  m_oPnlDEFL  .bSetUnits( wxT("Meter")     );
  m_oPnlDEFW  .bSetUnits( wxT("Meter")     );
  m_oPnlGMIN  .bSetUnits( wxT("Ohm")       );
  m_oPnlPIVREL.bSetUnits( wxT("%")         );
  m_oPnlRELTOL.bSetUnits( wxT("%")         );

  // Create the choice box control
  poPnl1 = new wxPanel( poPnlRHS_Opts );
  m_oLblMETHOD.Create( poPnl1, ID_UNUSED, wxT("METHOD"), wxDefaultPosition,
                       wxSize( 80, -1 ), wxST_NO_AUTORESIZE );
  m_oChoMETHOD.Create( poPnl1, ID_CHO_METHOD, wxDefaultPosition,
                       wxSize( 95, -1 ) );
  m_oChoMETHOD.Append( wxT("Trap") );
  m_oChoMETHOD.Append( wxT("Gear") );
  m_oChoMETHOD.SetSelection( 0 );

  // Create the check box control
  poPnl1 = new wxPanel( poPnlRHS_Opts );
  m_oCbxBADMOS3.Create( poPnl1, ID_CBX_BADMOS3, wxT("BADMOS3 \t  "),
                        wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                        wxALIGN_RIGHT );

  // Create the buttons
  m_oBtnOk      .Create( poPnlBtns, ID_BTN_OK,       wxT("OK")       );
  m_oBtnDefaults.Create( poPnlBtns, ID_BTN_DEFAULTS, wxT("Defaults") );
  m_oBtnCancel  .Create( poPnlBtns, ID_BTN_CANCEL,   wxT("Cancel")   );
}

//*****************************************************************************
// Initialize the tool tips.

void  DlgNgsCfgOPT::ToolTips( void )
{
  // Define tool tips for each control
  m_oPnlABSTOL .SetToolTip( wxT("Absolute current error tolerance") );
  m_oPnlCHGTOL .SetToolTip( wxT("Charge tolerance") );
  m_oPnlDEFAD  .SetToolTip( wxT("MOS drain diffusion area") );
  m_oPnlDEFAS  .SetToolTip( wxT("MOS source diffusion area") );
  m_oPnlDEFL   .SetToolTip( wxT("MOS channel length") );
  m_oPnlDEFW   .SetToolTip( wxT("MOS channel width") );
  m_oPnlGMIN   .SetToolTip( wxT("Minimum allowable conductance") );
  m_oPnlITL1   .SetToolTip( wxT("DC iteration limit") );
  m_oPnlITL2   .SetToolTip( wxT("DC transfer curve iteration limit") );
  m_oPnlITL4   .SetToolTip( wxT("Transient analysis timepoint iteration limit") );
  m_oPnlPIVREL .SetToolTip( wxT("Relative ratio between largest column entry and an acceptable pivot value") );
  m_oPnlPIVTOL .SetToolTip( wxT("Absolute minimum value for matrix entry as pivot") );
  m_oPnlRELTOL .SetToolTip( wxT("Relative error tolerance") );
  m_oPnlTEMP   .SetToolTip( wxT("Operating temperature of circuit") );
  m_oPnlTNOM   .SetToolTip( wxT("Nominal temperature at which device parameters measured") );
  m_oPnlTRTOL  .SetToolTip( wxT("Transient error tolerance") );
  m_oPnlVNTOL  .SetToolTip( wxT("Absolute voltage error tolerance") );

  m_oCbxBADMOS3.SetToolTip( wxT("Use MOS3 model with \"kappa\" discontinuity") );

  m_oChoMETHOD.GetParent( )->SetToolTip( wxT("Numerical integration method") );
}

//*****************************************************************************
// Layout the dialog display objects.

void  DlgNgsCfgOPT::DoLayout( void )
{
  wxBoxSizer  * poSzrDlg;
  wxPanel     * poPnlLHS, * poPnlRHS, * poPnlRHS_Opts, * poPnlBtns;
  wxPanel     * poPnlMETHOD, * poPnlCbxs;
  wxBoxSizer  * poSzrLHS, * poSzrRHS, * poSzrRHS_Opts, * poSzrBtns;
  wxBoxSizer  * poSzrMETHOD, * poSzrCbxs;
  wxSizerFlags  oFlags;

  // Get pointers to the various panels
  poPnlBtns     = (wxPanel *) m_oBtnOk     .GetParent( );
  poPnlLHS      = (wxPanel *) m_oPnlABSTOL .GetParent( );
  poPnlRHS      = (wxPanel *) poPnlBtns   ->GetParent( );
  poPnlRHS_Opts = (wxPanel *) m_oPnlVNTOL  .GetParent( );
  poPnlMETHOD   = (wxPanel *) m_oChoMETHOD .GetParent( );
  poPnlCbxs     = (wxPanel *) m_oCbxBADMOS3.GetParent( );

  // Create sizers to associate with the panels
  poSzrDlg      = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrLHS      = new wxStaticBoxSizer( wxVERTICAL, poPnlLHS );
  poSzrRHS      = new wxBoxSizer      ( wxVERTICAL );
  poSzrRHS_Opts = new wxStaticBoxSizer( wxVERTICAL, poPnlRHS_Opts );
  poSzrBtns     = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrMETHOD   = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrCbxs     = new wxBoxSizer      ( wxVERTICAL );

  // Set the sizers to the panels
                 SetSizer( poSzrDlg );
  poPnlLHS     ->SetSizer( poSzrLHS );
  poPnlRHS     ->SetSizer( poSzrRHS );
  poPnlRHS_Opts->SetSizer( poSzrRHS_Opts );
  poPnlBtns    ->SetSizer( poSzrBtns );
  poPnlMETHOD  ->SetSizer( poSzrMETHOD );
  poPnlCbxs    ->SetSizer( poSzrCbxs );

  // Layout the choice control panel
  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxTOP | wxBOTTOM, 1 );
  poSzrMETHOD->Add( &m_oLblMETHOD, oFlags );
  poSzrMETHOD->Add( &m_oChoMETHOD, oFlags );
  poSzrMETHOD->SetSizeHints( poPnlMETHOD );

  // Layout the check box panel
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxTOP, 3 );
  poSzrCbxs->Add( &m_oCbxBADMOS3, oFlags );
  poSzrCbxs->SetSizeHints( poPnlCbxs );

  // Layout the left hand panel
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxLEFT | wxRIGHT | wxTOP, 10 );
  poSzrLHS->Add( &m_oPnlABSTOL, oFlags );
  oFlags.Border( wxLEFT,                   10 );
  poSzrLHS->Add( &m_oPnlCHGTOL, oFlags );
  poSzrLHS->Add( &m_oPnlDEFAD,  oFlags );
  poSzrLHS->Add( &m_oPnlDEFAS,  oFlags );
  poSzrLHS->Add( &m_oPnlDEFL,   oFlags );
  poSzrLHS->Add( &m_oPnlDEFW,   oFlags );
  poSzrLHS->Add( &m_oPnlGMIN,   oFlags );
  poSzrLHS->Add( &m_oPnlITL1,   oFlags );
  poSzrLHS->Add( &m_oPnlITL2,   oFlags );
  poSzrLHS->Add( &m_oPnlITL4,   oFlags );
  oFlags.Border( wxLEFT | wxBOTTOM,        10 );
  poSzrLHS->Add( &m_oPnlPIVREL, oFlags );
  poSzrLHS->SetSizeHints( poPnlLHS );

  // Layout the right hand options panel
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxLEFT | wxTOP | wxRIGHT, 10 );
  poSzrRHS_Opts->Add( &m_oPnlPIVTOL, oFlags );
  oFlags.Border( wxLEFT,                   10 );
  poSzrRHS_Opts->Add( &m_oPnlRELTOL, oFlags );
  poSzrRHS_Opts->Add( &m_oPnlTEMP,   oFlags );
  poSzrRHS_Opts->Add( &m_oPnlTNOM,   oFlags );
  poSzrRHS_Opts->Add( &m_oPnlTRTOL,  oFlags );
  poSzrRHS_Opts->Add( &m_oPnlVNTOL,  oFlags );
  poSzrRHS_Opts->Add( poPnlMETHOD,   oFlags );
  oFlags.Border( wxLEFT | wxBOTTOM,         8 );
  poSzrRHS_Opts->Add( poPnlCbxs,     oFlags );
  poSzrRHS_Opts->SetSizeHints( poPnlRHS_Opts );

  // Layout the buttons panel
  oFlags.Border( wxTOP | wxBOTTOM, 0 );
  oFlags.Align( wxALIGN_RIGHT );
  poSzrBtns->Add( &m_oBtnOk,       oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_CENTER );
  poSzrBtns->Add( &m_oBtnDefaults, oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_LEFT );
  poSzrBtns->Add( &m_oBtnCancel,   oFlags );
  poSzrBtns->SetSizeHints( poPnlBtns );

  // Layout the right hand panel
  oFlags.Align( wxALIGN_TOP );
  oFlags.Border( wxALL, 0 );
  poSzrRHS->Add( poPnlRHS_Opts, oFlags );
  oFlags.Align( wxALIGN_BOTTOM | wxALIGN_CENTER_HORIZONTAL );
  oFlags.Border( wxTOP, 60 );
  poSzrRHS->Add( poPnlBtns,     oFlags );
  poSzrRHS->SetSizeHints( poPnlRHS );

  // Layout the overall dialog
  oFlags.Align( wxALIGN_TOP | wxALIGN_CENTER_HORIZONTAL );
  oFlags.Border( wxALL,                      15 );
  GetSizer( )->Add( poPnlLHS, oFlags );
  oFlags.Border( wxTOP | wxRIGHT | wxBOTTOM, 15 );
  GetSizer( )->Add( poPnlRHS, oFlags );
  GetSizer( )->SetSizeHints( this );
}

//*****************************************************************************
// Get a pointer to a value panel associated with a control ID number.
//
// Argument List :
//   iPnlID - The control ID number
//
// Return Values :
//   Success - A pointer to the value panel
//   Failure - NULL

PnlValue * DlgNgsCfgOPT::poGetPanel( int iPnlID )
{
  switch( iPnlID )
  {
    case ID_PNL_ABSTOL : return( &m_oPnlABSTOL );
    case ID_PNL_CHGTOL : return( &m_oPnlCHGTOL );
    case ID_PNL_DEFAD  : return( &m_oPnlDEFAD  );
    case ID_PNL_DEFAS  : return( &m_oPnlDEFAS  );
    case ID_PNL_DEFL   : return( &m_oPnlDEFL   );
    case ID_PNL_DEFW   : return( &m_oPnlDEFW   );
    case ID_PNL_GMIN   : return( &m_oPnlGMIN   );
    case ID_PNL_ITL1   : return( &m_oPnlITL1   );
    case ID_PNL_ITL2   : return( &m_oPnlITL2   );
    case ID_PNL_ITL4   : return( &m_oPnlITL4   );
    case ID_PNL_PIVREL : return( &m_oPnlPIVREL );
    case ID_PNL_PIVTOL : return( &m_oPnlPIVTOL );
    case ID_PNL_RELTOL : return( &m_oPnlRELTOL );
    case ID_PNL_TEMP   : return( &m_oPnlTEMP   );
    case ID_PNL_TNOM   : return( &m_oPnlTNOM   );
    case ID_PNL_TRTOL  : return( &m_oPnlTRTOL  );
    case ID_PNL_VNTOL  : return( &m_oPnlVNTOL  );
    default            : return( NULL );
  }
}

//*****************************************************************************
// Set the values in the value panel controls.
//
// Argument List :
//   rosCmdOPT - A reference to an OPTION command object

void  DlgNgsCfgOPT::SetValues( CmdNgSpiceOPT & roCmdOPT )
{
  double  df1;
  int     i1;

  SetEvtHandlerEnabled( FALSE );

  m_oPnlABSTOL.bSetValue ( roCmdOPT.m_osABSTOL );
  m_oPnlCHGTOL.bSetValue ( roCmdOPT.m_osCHGTOL );
  m_oPnlDEFAD .bSetValue ( roCmdOPT.m_osDEFAD  );
  m_oPnlDEFAS .bSetValue ( roCmdOPT.m_osDEFAS  );
  m_oPnlDEFL  .bSetValue ( roCmdOPT.m_osDEFL   );
  m_oPnlDEFW  .bSetValue ( roCmdOPT.m_osDEFW   );
  m_oPnlGMIN  .bSetValue ( roCmdOPT.m_osGMIN   );
  m_oPnlITL1  .bSetValue ( roCmdOPT.m_osITL1   );
  m_oPnlITL2  .bSetValue ( roCmdOPT.m_osITL2   );
  m_oPnlITL4  .bSetValue ( roCmdOPT.m_osITL4   );
  m_oPnlPIVTOL.bSetValue ( roCmdOPT.m_osPIVTOL );
  m_oPnlTEMP  .bSetValue ( roCmdOPT.m_osTEMP   );
  m_oPnlTNOM  .bSetValue ( roCmdOPT.m_osTNOM   );
  m_oPnlTRTOL .bSetValue ( roCmdOPT.m_osTRTOL  );
  m_oPnlVNTOL .bSetValue ( roCmdOPT.m_osVNTOL  );

  ConvertType::bStrToDFlt( roCmdOPT.m_osPIVREL, &df1 );
  m_oPnlPIVREL.bSetValue ( df1 * 100.0 );

  ConvertType::bStrToDFlt( roCmdOPT.m_osRELTOL, &df1 );
  m_oPnlRELTOL.bSetValue ( df1 * 100.0 );

  m_oCbxBADMOS3.SetValue ( roCmdOPT.m_bBADMOS3 );

  for( i1=0; i1<(int)m_oChoMETHOD.GetCount( ); i1++ )
    if( m_oChoMETHOD.GetString( i1 ).IsSameAs( roCmdOPT.m_osMETHOD, FALSE ) )
      { m_oChoMETHOD.SetSelection( i1 ); break; }

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Get the values from the value panel controls.
//
// Argument List :
//   rosCmdOPT - A reference to an OPTION command object

void  DlgNgsCfgOPT::GetValues( CmdNgSpiceOPT & roCmdOPT )
{
  SetEvtHandlerEnabled( FALSE );

  roCmdOPT.m_osABSTOL = m_oPnlABSTOL.rosGetValue( );
  roCmdOPT.m_osCHGTOL = m_oPnlCHGTOL.rosGetValue( );
  roCmdOPT.m_osDEFAD  = m_oPnlDEFAD .rosGetValue( );
  roCmdOPT.m_osDEFAS  = m_oPnlDEFAS .rosGetValue( );
  roCmdOPT.m_osDEFL   = m_oPnlDEFL  .rosGetValue( );
  roCmdOPT.m_osDEFW   = m_oPnlDEFW  .rosGetValue( );
  roCmdOPT.m_osGMIN   = m_oPnlGMIN  .rosGetValue( );
  roCmdOPT.m_osITL1   = m_oPnlITL1  .rosGetValue( );
  roCmdOPT.m_osITL2   = m_oPnlITL2  .rosGetValue( );
  roCmdOPT.m_osITL4   = m_oPnlITL4  .rosGetValue( );
  roCmdOPT.m_osPIVTOL = m_oPnlPIVTOL.rosGetValue( );
  roCmdOPT.m_osTEMP   = m_oPnlTEMP  .rosGetValue( );
  roCmdOPT.m_osTNOM   = m_oPnlTNOM  .rosGetValue( );
  roCmdOPT.m_osTRTOL  = m_oPnlTRTOL .rosGetValue( );
  roCmdOPT.m_osVNTOL  = m_oPnlVNTOL .rosGetValue( );

  ConvertType::bFltToStr( m_oPnlPIVREL.dfGetValue()/100.0, roCmdOPT.m_osPIVREL );
  roCmdOPT.m_osPIVREL.Trim( FALSE );

  ConvertType::bFltToStr( m_oPnlRELTOL.dfGetValue()/100.0, roCmdOPT.m_osRELTOL );
  roCmdOPT.m_osRELTOL.Trim( FALSE );

  roCmdOPT.m_bBADMOS3 = m_oCbxBADMOS3.GetValue( );

  roCmdOPT.m_osMETHOD = m_oChoMETHOD.GetStringSelection( ).Upper( );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Set the values in the value panel controls.
//
// Argument List :
//   roCmdOPT - A reference to an OPTION command object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgsCfgOPT::bSetValues( CmdNgSpiceOPT & roCmdOPT )
{
  SetValues( roCmdOPT );
  m_oCmdOPT = roCmdOPT;

  return( TRUE );
}

//*****************************************************************************
// Get the values from the value panel controls.
//
// Argument List :
//   roCmdOPT - A reference to an OPTION command object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgsCfgOPT::bGetValues( CmdNgSpiceOPT & roCmdOPT )
{
  GetValues( roCmdOPT );

  return( TRUE );
}

//*****************************************************************************
// Reset all dialog settings to defaults.
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgsCfgOPT::bClear( void )
{
  m_oCmdOPT.bSetDefaults( );

  SetValues( m_oCmdOPT );

  return( TRUE );
}

//*****************************************************************************
// Get a value panel control's value.
//
// Argument List :
//   iPnlID - Value panel control identifier
//
// Return Values :
//   Success - The panel value
//   Failure - An empty string

const wxString & DlgNgsCfgOPT::rosGetValue( int iPnlID )
{
  static  wxString  osEmpty;
  PnlValue * poPnlValue;

  poPnlValue = poGetPanel( iPnlID );
  if( poPnlValue == NULL ) return( osEmpty );

  return( poPnlValue->rosGetValue( ) );
}

//*****************************************************************************
// Set a value panel control's value.
//
// Argument List :
//   iPnlID   - Value panel control identifier
//   rosValue - The value to set
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgsCfgOPT::bSetValue( int iPnlID, const wxString & rosValue )
{
  PnlValue * poPnlValue;

  // Get a pointer to the appropriate value panel
  poPnlValue = poGetPanel( iPnlID );
  if( poPnlValue == NULL )                  return( FALSE );

  // Set the panel value
  if( ! poPnlValue->bSetValue( rosValue ) ) return( FALSE );

  // Update the OPTIONS command object
  GetValues( m_oCmdOPT );

  return( TRUE );
}

//*****************************************************************************
//
//                             Event Handlers
//
//*****************************************************************************
// Ok button event handler.
//
// Argument List :
//   roEvtCmd - An object holding information about the event (not used)

void  DlgNgsCfgOPT::OnBtnOk( wxCommandEvent & roEvtCmd )
{
  GetValues( m_oCmdOPT );
  EndModal( wxID_OK );
}

//*****************************************************************************
// Defaults button event handler.
//
// Argument List :
//   roEvtCmd - An object holding information about the event (not used)

void  DlgNgsCfgOPT::OnBtnDefaults( wxCommandEvent & roEvtCmd )
{
  CmdNgSpiceOPT  oCmdOPT;

  oCmdOPT.bSetDefaults( );
  SetValues( oCmdOPT );
}

//*****************************************************************************
// Cancel button event handler.
//
// Argument List :
//   roEvtCmd - An object holding information about the event (not used)

void  DlgNgsCfgOPT::OnBtnCancel( wxCommandEvent & roEvtCmd )
{
  SetValues( m_oCmdOPT );
  EndModal( wxID_CANCEL );
}

//*****************************************************************************
