//*****************************************************************************
//                              CmdNgSpiceOPT.hpp                             *
//                             -------------------                            *
// Description : This class contains values associated with the NG-Spice      *
//               OPTIONS command. It inherits from the class CmdBase.         *
// Started     : 23/08/2006                                                   *
// Last Update : 21/04/2011                                                   *
// Copyright   : (C) 2006 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSOPT_HPP
#define CMDNGSOPT_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "gnucap/commands/CmdGnuCapOPT.hpp"
#include "utility/ConvertType.hpp"

struct CmdGnuCapOPT;

// Local Macro and/or Constant Declarations

#define  NGS_ABSTOL   1.00E-12
#define  NGS_BADMOS3  FALSE
#define  NGS_CHGTOL   1.00E-14
#define  NGS_DEFAD    0.00
#define  NGS_DEFAS    0.00
#define  NGS_DEFL     100.00E-06
#define  NGS_DEFW     100.00E-06
#define  NGS_GMIN     1.00E-12
#define  NGS_ITL1     100
#define  NGS_ITL2     50
#define  NGS_ITL4     10
#define  NGS_METHOD   wxT("Trap")
#define  NGS_PIVREL   1.00E-03
#define  NGS_PIVTOL   1.00E-13
#define  NGS_RELTOL   1.00E-03
#define  NGS_TEMP     27.00
#define  NGS_TNOM     27.00
#define  NGS_TRTOL    7.00
#define  NGS_VNTOL    1.00E-06

#define  NGS_WIDTH    104  // Allows for operator (eg. frequency) & 10 cols of data
#define  NGS_NUMDGT   6
#define  NGS_UNITS    wxT("Degrees")

//*****************************************************************************

struct CmdNgSpiceOPT : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    // Options supported by both NG-Spice and GNU-Cap
    wxString  m_osABSTOL;  // Abs. current error tolerance
    wxString  m_osCHGTOL;  // Charge tolerance
    wxString  m_osDEFAD;   // MOS drain diffusion area
    wxString  m_osDEFAS;   // MOS source diffusion area
    wxString  m_osDEFL;    // MOS channel length
    wxString  m_osDEFW;    // MOS channel width
    wxString  m_osGMIN;    // Minimum allowable conductance
    wxString  m_osITL1;    // DC iteration limit
    wxString  m_osITL2;    // DC transfer curve iteration limit
    wxString  m_osITL4;    // TR analysis timepoint iteration limit
    wxString  m_osMETHOD;  // Numerical integration method
    wxString  m_osRELTOL;  // Relative error tolerance
    wxString  m_osTNOM;    // Nominal temp. at which device parameters measured
    wxString  m_osTRTOL;   // TR error tolerance
    wxString  m_osVNTOL;   // Abs. voltage error tolerance

    // Options specific to NG-Spice
    bool      m_bBADMOS3;  // Use MOS3 model with "kappa" discontinuity
    wxString  m_osPIVREL;  // Relative ratio of largest column entry and an acceptable pivot value
    wxString  m_osPIVTOL;  // Abs. min. value for matrix entry as pivot
    wxString  m_osTEMP;    // Operating temperature of circuit

    // Options to set the results format
    uint      m_uiWidth;   // Width of the results page
    uint      m_uiNumDgt;  // Number of digits of precision
    wxString  m_osUnits;   // Angle units : degrees or radians

              CmdNgSpiceOPT( void );
    virtual  ~CmdNgSpiceOPT( );

    virtual  bool  bSetDefaults( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

             bool  bSetWidth( uint uiParaCnt );

    CmdNgSpiceOPT & operator = ( const CmdGnuCapOPT & roCmdOPT );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDNGSOPT_HPP
