library ieee;
use ieee.std_logic_1164.all;


library ieee;
use ieee.numeric_std.all;

entity ilb_table is
	port (
		clk : in  std_logic;
		ra0_data : out std_logic_vector(31 downto 0);
		ra0_addr : in  std_logic_vector(4 downto 0)
	);
end ilb_table;
architecture augh of ilb_table is

	-- Embedded RAM

	type ram_type is array (0 to 31) of std_logic_vector(31 downto 0);
	signal ram : ram_type := ("00000000000000000000100000000000", "00000000000000000000100000101101", "00000000000000000000100001011011", "00000000000000000000100010001010", "00000000000000000000100010111001", "00000000000000000000100011101010", "00000000000000000000100100011100", "00000000000000000000100101001111", "00000000000000000000100110000011", "00000000000000000000100110111001", "00000000000000000000100111101111", "00000000000000000000101000100111", "00000000000000000000101001100000", "00000000000000000000101010011010", "00000000000000000000101011010110", "00000000000000000000101100010010", "00000000000000000000101101010000", "00000000000000000000101110010000", "00000000000000000000101111010001", "00000000000000000000110000010011", "00000000000000000000110001010110", "00000000000000000000110010011100", "00000000000000000000110011100010", "00000000000000000000110100101011", "00000000000000000000110101110100", "00000000000000000000110111000000", "00000000000000000000111000001101", "00000000000000000000111001011100", "00000000000000000000111010101100", "00000000000000000000111011111110", "00000000000000000000111101010010", "00000000000000000000111110101000");


	-- Little utility functions to make VHDL syntactically correct
	--   with the syntax to_integer(unsigned(vector)) when 'vector' is a std_logic.
	--   This happens when accessing arrays with <= 2 cells, for example.

	function to_integer(B: std_logic) return integer is
		variable V: std_logic_vector(0 to 0);
	begin
		V(0) := B;
		return to_integer(unsigned(V));
	end;

	function to_integer(V: std_logic_vector) return integer is
	begin
		return to_integer(unsigned(V));
	end;

begin

	-- The component is a ROM.
	-- There is no Write side.

	-- The Read side (the outputs)

	ra0_data <= ram( to_integer(ra0_addr) );

end architecture;
