/* SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause */
/*
 * Copyright (C) 2024 Intel Corporation
 */
#ifndef __iwl_mld_constants_h__
#define __iwl_mld_constants_h__

#define IWL_MLD_MISSED_BEACONS_SINCE_RX_THOLD			4
#define IWL_MLD_MISSED_BEACONS_THRESHOLD			8
#define IWL_MLD_MISSED_BEACONS_THRESHOLD_LONG			19
#define IWL_MLD_BCN_LOSS_EXIT_ESR_THRESH_2_LINKS		5
#define IWL_MLD_BCN_LOSS_EXIT_ESR_THRESH			15
#define IWL_MLD_BCN_LOSS_EXIT_ESR_THRESH_BSS_PARAM_CHANGED	11

#define IWL_MLD_DEFAULT_PS_TX_DATA_TIMEOUT	(100 * USEC_PER_MSEC)
#define IWL_MLD_DEFAULT_PS_RX_DATA_TIMEOUT	(100 * USEC_PER_MSEC)
#define IWL_MLD_WOWLAN_PS_TX_DATA_TIMEOUT	(10 * USEC_PER_MSEC)
#define IWL_MLD_WOWLAN_PS_RX_DATA_TIMEOUT	(10 * USEC_PER_MSEC)
#define IWL_MLD_SHORT_PS_TX_DATA_TIMEOUT	(2 * 1024) /* defined in TU */
#define IWL_MLD_SHORT_PS_RX_DATA_TIMEOUT	(40 * 1024) /* defined in TU */

#define IWL_MLD_UAPSD_RX_DATA_TIMEOUT		(50 * USEC_PER_MSEC)
#define IWL_MLD_UAPSD_TX_DATA_TIMEOUT		(50 * USEC_PER_MSEC)

#define IWL_MLD_PS_SNOOZE_INTERVAL		25
#define IWL_MLD_PS_SNOOZE_INTERVAL		25
#define IWL_MLD_PS_SNOOZE_WINDOW		50

#define IWL_MLD_PS_SNOOZE_HEAVY_TX_THLD_PACKETS	30
#define IWL_MLD_PS_SNOOZE_HEAVY_RX_THLD_PACKETS	20

#define IWL_MLD_PS_HEAVY_TX_THLD_PERCENT	50
#define IWL_MLD_PS_HEAVY_RX_THLD_PERCENT	50
#define IWL_MLD_PS_HEAVY_TX_THLD_PACKETS	20
#define IWL_MLD_PS_HEAVY_RX_THLD_PACKETS	8

#endif /* __iwl_mld_constants_h__ */
