# Copyright 2019 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <https://www.gnu.org/licenses/>.

# Make coding more python3-ish
from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import os
import json
import pytest
from mock import ANY
from ansible.module_utils.network.fortios.fortios import FortiOSHandler

try:
    from ansible.modules.network.fortios import fortios_vpn_ipsec_phase1_interface
except ImportError:
    pytest.skip("Could not load required modules for testing", allow_module_level=True)


@pytest.fixture(autouse=True)
def connection_mock(mocker):
    connection_class_mock = mocker.patch('ansible.modules.network.fortios.fortios_vpn_ipsec_phase1_interface.Connection')
    return connection_class_mock


fos_instance = FortiOSHandler(connection_mock)


def test_vpn_ipsec_phase1_interface_creation(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'vpn_ipsec_phase1_interface': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_discovery_forwarder': 'enable',
            'auto_discovery_psk': 'enable',
            'auto_discovery_receiver': 'enable',
            'auto_discovery_sender': 'enable',
            'auto_negotiate': 'enable',
            'banner': 'test_value_18',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_23',
            'default_gw': 'test_value_24',
            'default_gw_priority': '25',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '28',
            'dns_mode': 'manual',
            'domain': 'test_value_30',
            'dpd': 'disable',
            'dpd_retrycount': '32',
            'dpd_retryinterval': 'test_value_33',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'encap_local_gw4': 'test_value_36',
            'encap_local_gw6': 'test_value_37',
            'encap_remote_gw4': 'test_value_38',
            'encap_remote_gw6': 'test_value_39',
            'encapsulation': 'none',
            'encapsulation_address': 'ike',
            'enforce_unique_id': 'disable',
            'exchange_interface_ip': 'enable',
            'exchange_ip_addr4': 'test_value_44',
            'exchange_ip_addr6': 'test_value_45',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '48',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_50',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '53',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_56',
            'ip_version': '4',
            'ipv4_dns_server1': 'test_value_58',
            'ipv4_dns_server2': 'test_value_59',
            'ipv4_dns_server3': 'test_value_60',
            'ipv4_end_ip': 'test_value_61',
            'ipv4_name': 'test_value_62',
            'ipv4_netmask': 'test_value_63',
            'ipv4_split_exclude': 'test_value_64',
            'ipv4_split_include': 'test_value_65',
            'ipv4_start_ip': 'test_value_66',
            'ipv4_wins_server1': 'test_value_67',
            'ipv4_wins_server2': 'test_value_68',
            'ipv6_dns_server1': 'test_value_69',
            'ipv6_dns_server2': 'test_value_70',
            'ipv6_dns_server3': 'test_value_71',
            'ipv6_end_ip': 'test_value_72',
            'ipv6_name': 'test_value_73',
            'ipv6_prefix': '74',
            'ipv6_split_exclude': 'test_value_75',
            'ipv6_split_include': 'test_value_76',
            'ipv6_start_ip': 'test_value_77',
            'keepalive': '78',
            'keylife': '79',
            'local_gw': 'test_value_80',
            'local_gw6': 'test_value_81',
            'localid': 'test_value_82',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'monitor': 'test_value_87',
            'monitor_hold_down_delay': '88',
            'monitor_hold_down_time': 'test_value_89',
            'monitor_hold_down_type': 'immediate',
            'monitor_hold_down_weekday': 'everyday',
            'name': 'default_name_92',
            'nattraversal': 'enable',
            'negotiate_timeout': '94',
            'net_device': 'enable',
            'passive_mode': 'enable',
            'peer': 'test_value_97',
            'peergrp': 'test_value_98',
            'peerid': 'test_value_99',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_102',
            'ppk_secret': 'test_value_103',
            'priority': '104',
            'proposal': 'des-md5',
            'psksecret': 'test_value_106',
            'psksecret_remote': 'test_value_107',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_110',
            'remote_gw6': 'test_value_111',
            'remotegw_ddns': 'test_value_112',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_117',
            'suite_b': 'disable',
            'tunnel_search': 'selectors',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_122',
            'vni': '123',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1_interface.fortios_vpn_ipsec(input_data, fos_instance)

    expected_data = {
        'acct-verify': 'enable',
        'add-gw-route': 'enable',
        'add-route': 'disable',
        'assign-ip': 'disable',
        'assign-ip-from': 'range',
        'authmethod': 'psk',
        'authmethod-remote': 'psk',
        'authpasswd': 'test_value_10',
        'authusr': 'test_value_11',
        'authusrgrp': 'test_value_12',
        'auto-discovery-forwarder': 'enable',
        'auto-discovery-psk': 'enable',
        'auto-discovery-receiver': 'enable',
        'auto-discovery-sender': 'enable',
        'auto-negotiate': 'enable',
        'banner': 'test_value_18',
        'cert-id-validation': 'enable',
        'childless-ike': 'enable',
        'client-auto-negotiate': 'disable',
        'client-keep-alive': 'disable',
        'comments': 'test_value_23',
        'default-gw': 'test_value_24',
        'default-gw-priority': '25',
        'dhgrp': '1',
        'digital-signature-auth': 'enable',
        'distance': '28',
        'dns-mode': 'manual',
        'domain': 'test_value_30',
        'dpd': 'disable',
        'dpd-retrycount': '32',
        'dpd-retryinterval': 'test_value_33',
        'eap': 'enable',
        'eap-identity': 'use-id-payload',
        'encap-local-gw4': 'test_value_36',
        'encap-local-gw6': 'test_value_37',
        'encap-remote-gw4': 'test_value_38',
        'encap-remote-gw6': 'test_value_39',
        'encapsulation': 'none',
        'encapsulation-address': 'ike',
        'enforce-unique-id': 'disable',
        'exchange-interface-ip': 'enable',
        'exchange-ip-addr4': 'test_value_44',
        'exchange-ip-addr6': 'test_value_45',
        'forticlient-enforcement': 'enable',
        'fragmentation': 'enable',
        'fragmentation-mtu': '48',
        'group-authentication': 'enable',
        'group-authentication-secret': 'test_value_50',
        'ha-sync-esp-seqno': 'enable',
        'idle-timeout': 'enable',
        'idle-timeoutinterval': '53',
        'ike-version': '1',
        'include-local-lan': 'disable',
        'interface': 'test_value_56',
        'ip-version': '4',
        'ipv4-dns-server1': 'test_value_58',
        'ipv4-dns-server2': 'test_value_59',
        'ipv4-dns-server3': 'test_value_60',
        'ipv4-end-ip': 'test_value_61',
        'ipv4-name': 'test_value_62',
        'ipv4-netmask': 'test_value_63',
        'ipv4-split-exclude': 'test_value_64',
        'ipv4-split-include': 'test_value_65',
        'ipv4-start-ip': 'test_value_66',
        'ipv4-wins-server1': 'test_value_67',
        'ipv4-wins-server2': 'test_value_68',
        'ipv6-dns-server1': 'test_value_69',
        'ipv6-dns-server2': 'test_value_70',
        'ipv6-dns-server3': 'test_value_71',
        'ipv6-end-ip': 'test_value_72',
        'ipv6-name': 'test_value_73',
        'ipv6-prefix': '74',
        'ipv6-split-exclude': 'test_value_75',
        'ipv6-split-include': 'test_value_76',
        'ipv6-start-ip': 'test_value_77',
        'keepalive': '78',
        'keylife': '79',
        'local-gw': 'test_value_80',
        'local-gw6': 'test_value_81',
        'localid': 'test_value_82',
        'localid-type': 'auto',
        'mesh-selector-type': 'disable',
        'mode': 'aggressive',
                'mode-cfg': 'disable',
                'monitor': 'test_value_87',
                'monitor-hold-down-delay': '88',
                'monitor-hold-down-time': 'test_value_89',
                'monitor-hold-down-type': 'immediate',
                'monitor-hold-down-weekday': 'everyday',
                'name': 'default_name_92',
                'nattraversal': 'enable',
                'negotiate-timeout': '94',
                'net-device': 'enable',
                'passive-mode': 'enable',
                'peer': 'test_value_97',
                'peergrp': 'test_value_98',
                'peerid': 'test_value_99',
                'peertype': 'any',
                'ppk': 'disable',
                'ppk-identity': 'test_value_102',
                'ppk-secret': 'test_value_103',
                'priority': '104',
                'proposal': 'des-md5',
                'psksecret': 'test_value_106',
                'psksecret-remote': 'test_value_107',
                'reauth': 'disable',
                'rekey': 'enable',
                'remote-gw': 'test_value_110',
                'remote-gw6': 'test_value_111',
                'remotegw-ddns': 'test_value_112',
                'rsa-signature-format': 'pkcs1',
                'save-password': 'disable',
                'send-cert-chain': 'enable',
                'signature-hash-alg': 'sha1',
                'split-include-service': 'test_value_117',
                'suite-b': 'disable',
                'tunnel-search': 'selectors',
                'type': 'static',
                'unity-support': 'disable',
                'usrgrp': 'test_value_122',
                'vni': '123',
                'wizard-type': 'custom',
                'xauthtype': 'disable'
    }

    set_method_mock.assert_called_with('vpn.ipsec', 'phase1-interface', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_vpn_ipsec_phase1_interface_creation_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'vpn_ipsec_phase1_interface': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_discovery_forwarder': 'enable',
            'auto_discovery_psk': 'enable',
            'auto_discovery_receiver': 'enable',
            'auto_discovery_sender': 'enable',
            'auto_negotiate': 'enable',
            'banner': 'test_value_18',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_23',
            'default_gw': 'test_value_24',
            'default_gw_priority': '25',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '28',
            'dns_mode': 'manual',
            'domain': 'test_value_30',
            'dpd': 'disable',
            'dpd_retrycount': '32',
            'dpd_retryinterval': 'test_value_33',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'encap_local_gw4': 'test_value_36',
            'encap_local_gw6': 'test_value_37',
            'encap_remote_gw4': 'test_value_38',
            'encap_remote_gw6': 'test_value_39',
            'encapsulation': 'none',
            'encapsulation_address': 'ike',
            'enforce_unique_id': 'disable',
            'exchange_interface_ip': 'enable',
            'exchange_ip_addr4': 'test_value_44',
            'exchange_ip_addr6': 'test_value_45',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '48',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_50',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '53',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_56',
            'ip_version': '4',
            'ipv4_dns_server1': 'test_value_58',
            'ipv4_dns_server2': 'test_value_59',
            'ipv4_dns_server3': 'test_value_60',
            'ipv4_end_ip': 'test_value_61',
            'ipv4_name': 'test_value_62',
            'ipv4_netmask': 'test_value_63',
            'ipv4_split_exclude': 'test_value_64',
            'ipv4_split_include': 'test_value_65',
            'ipv4_start_ip': 'test_value_66',
            'ipv4_wins_server1': 'test_value_67',
            'ipv4_wins_server2': 'test_value_68',
            'ipv6_dns_server1': 'test_value_69',
            'ipv6_dns_server2': 'test_value_70',
            'ipv6_dns_server3': 'test_value_71',
            'ipv6_end_ip': 'test_value_72',
            'ipv6_name': 'test_value_73',
            'ipv6_prefix': '74',
            'ipv6_split_exclude': 'test_value_75',
            'ipv6_split_include': 'test_value_76',
            'ipv6_start_ip': 'test_value_77',
            'keepalive': '78',
            'keylife': '79',
            'local_gw': 'test_value_80',
            'local_gw6': 'test_value_81',
            'localid': 'test_value_82',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'monitor': 'test_value_87',
            'monitor_hold_down_delay': '88',
            'monitor_hold_down_time': 'test_value_89',
            'monitor_hold_down_type': 'immediate',
            'monitor_hold_down_weekday': 'everyday',
            'name': 'default_name_92',
            'nattraversal': 'enable',
            'negotiate_timeout': '94',
            'net_device': 'enable',
            'passive_mode': 'enable',
            'peer': 'test_value_97',
            'peergrp': 'test_value_98',
            'peerid': 'test_value_99',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_102',
            'ppk_secret': 'test_value_103',
            'priority': '104',
            'proposal': 'des-md5',
            'psksecret': 'test_value_106',
            'psksecret_remote': 'test_value_107',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_110',
            'remote_gw6': 'test_value_111',
            'remotegw_ddns': 'test_value_112',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_117',
            'suite_b': 'disable',
            'tunnel_search': 'selectors',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_122',
            'vni': '123',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1_interface.fortios_vpn_ipsec(input_data, fos_instance)

    expected_data = {
        'acct-verify': 'enable',
        'add-gw-route': 'enable',
        'add-route': 'disable',
        'assign-ip': 'disable',
        'assign-ip-from': 'range',
        'authmethod': 'psk',
        'authmethod-remote': 'psk',
        'authpasswd': 'test_value_10',
        'authusr': 'test_value_11',
        'authusrgrp': 'test_value_12',
        'auto-discovery-forwarder': 'enable',
        'auto-discovery-psk': 'enable',
        'auto-discovery-receiver': 'enable',
        'auto-discovery-sender': 'enable',
        'auto-negotiate': 'enable',
        'banner': 'test_value_18',
        'cert-id-validation': 'enable',
        'childless-ike': 'enable',
        'client-auto-negotiate': 'disable',
        'client-keep-alive': 'disable',
        'comments': 'test_value_23',
        'default-gw': 'test_value_24',
        'default-gw-priority': '25',
        'dhgrp': '1',
        'digital-signature-auth': 'enable',
        'distance': '28',
        'dns-mode': 'manual',
        'domain': 'test_value_30',
        'dpd': 'disable',
        'dpd-retrycount': '32',
        'dpd-retryinterval': 'test_value_33',
        'eap': 'enable',
        'eap-identity': 'use-id-payload',
        'encap-local-gw4': 'test_value_36',
        'encap-local-gw6': 'test_value_37',
        'encap-remote-gw4': 'test_value_38',
        'encap-remote-gw6': 'test_value_39',
        'encapsulation': 'none',
        'encapsulation-address': 'ike',
        'enforce-unique-id': 'disable',
        'exchange-interface-ip': 'enable',
        'exchange-ip-addr4': 'test_value_44',
        'exchange-ip-addr6': 'test_value_45',
        'forticlient-enforcement': 'enable',
        'fragmentation': 'enable',
        'fragmentation-mtu': '48',
        'group-authentication': 'enable',
        'group-authentication-secret': 'test_value_50',
        'ha-sync-esp-seqno': 'enable',
        'idle-timeout': 'enable',
        'idle-timeoutinterval': '53',
        'ike-version': '1',
        'include-local-lan': 'disable',
        'interface': 'test_value_56',
        'ip-version': '4',
        'ipv4-dns-server1': 'test_value_58',
        'ipv4-dns-server2': 'test_value_59',
        'ipv4-dns-server3': 'test_value_60',
        'ipv4-end-ip': 'test_value_61',
        'ipv4-name': 'test_value_62',
        'ipv4-netmask': 'test_value_63',
        'ipv4-split-exclude': 'test_value_64',
        'ipv4-split-include': 'test_value_65',
        'ipv4-start-ip': 'test_value_66',
        'ipv4-wins-server1': 'test_value_67',
        'ipv4-wins-server2': 'test_value_68',
        'ipv6-dns-server1': 'test_value_69',
        'ipv6-dns-server2': 'test_value_70',
        'ipv6-dns-server3': 'test_value_71',
        'ipv6-end-ip': 'test_value_72',
        'ipv6-name': 'test_value_73',
        'ipv6-prefix': '74',
        'ipv6-split-exclude': 'test_value_75',
        'ipv6-split-include': 'test_value_76',
        'ipv6-start-ip': 'test_value_77',
        'keepalive': '78',
        'keylife': '79',
        'local-gw': 'test_value_80',
        'local-gw6': 'test_value_81',
        'localid': 'test_value_82',
        'localid-type': 'auto',
        'mesh-selector-type': 'disable',
        'mode': 'aggressive',
                'mode-cfg': 'disable',
                'monitor': 'test_value_87',
                'monitor-hold-down-delay': '88',
                'monitor-hold-down-time': 'test_value_89',
                'monitor-hold-down-type': 'immediate',
                'monitor-hold-down-weekday': 'everyday',
                'name': 'default_name_92',
                'nattraversal': 'enable',
                'negotiate-timeout': '94',
                'net-device': 'enable',
                'passive-mode': 'enable',
                'peer': 'test_value_97',
                'peergrp': 'test_value_98',
                'peerid': 'test_value_99',
                'peertype': 'any',
                'ppk': 'disable',
                'ppk-identity': 'test_value_102',
                'ppk-secret': 'test_value_103',
                'priority': '104',
                'proposal': 'des-md5',
                'psksecret': 'test_value_106',
                'psksecret-remote': 'test_value_107',
                'reauth': 'disable',
                'rekey': 'enable',
                'remote-gw': 'test_value_110',
                'remote-gw6': 'test_value_111',
                'remotegw-ddns': 'test_value_112',
                'rsa-signature-format': 'pkcs1',
                'save-password': 'disable',
                'send-cert-chain': 'enable',
                'signature-hash-alg': 'sha1',
                'split-include-service': 'test_value_117',
                'suite-b': 'disable',
                'tunnel-search': 'selectors',
                'type': 'static',
                'unity-support': 'disable',
                'usrgrp': 'test_value_122',
                'vni': '123',
                'wizard-type': 'custom',
                'xauthtype': 'disable'
    }

    set_method_mock.assert_called_with('vpn.ipsec', 'phase1-interface', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_vpn_ipsec_phase1_interface_removal(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'vpn_ipsec_phase1_interface': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_discovery_forwarder': 'enable',
            'auto_discovery_psk': 'enable',
            'auto_discovery_receiver': 'enable',
            'auto_discovery_sender': 'enable',
            'auto_negotiate': 'enable',
            'banner': 'test_value_18',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_23',
            'default_gw': 'test_value_24',
            'default_gw_priority': '25',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '28',
            'dns_mode': 'manual',
            'domain': 'test_value_30',
            'dpd': 'disable',
            'dpd_retrycount': '32',
            'dpd_retryinterval': 'test_value_33',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'encap_local_gw4': 'test_value_36',
            'encap_local_gw6': 'test_value_37',
            'encap_remote_gw4': 'test_value_38',
            'encap_remote_gw6': 'test_value_39',
            'encapsulation': 'none',
            'encapsulation_address': 'ike',
            'enforce_unique_id': 'disable',
            'exchange_interface_ip': 'enable',
            'exchange_ip_addr4': 'test_value_44',
            'exchange_ip_addr6': 'test_value_45',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '48',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_50',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '53',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_56',
            'ip_version': '4',
            'ipv4_dns_server1': 'test_value_58',
            'ipv4_dns_server2': 'test_value_59',
            'ipv4_dns_server3': 'test_value_60',
            'ipv4_end_ip': 'test_value_61',
            'ipv4_name': 'test_value_62',
            'ipv4_netmask': 'test_value_63',
            'ipv4_split_exclude': 'test_value_64',
            'ipv4_split_include': 'test_value_65',
            'ipv4_start_ip': 'test_value_66',
            'ipv4_wins_server1': 'test_value_67',
            'ipv4_wins_server2': 'test_value_68',
            'ipv6_dns_server1': 'test_value_69',
            'ipv6_dns_server2': 'test_value_70',
            'ipv6_dns_server3': 'test_value_71',
            'ipv6_end_ip': 'test_value_72',
            'ipv6_name': 'test_value_73',
            'ipv6_prefix': '74',
            'ipv6_split_exclude': 'test_value_75',
            'ipv6_split_include': 'test_value_76',
            'ipv6_start_ip': 'test_value_77',
            'keepalive': '78',
            'keylife': '79',
            'local_gw': 'test_value_80',
            'local_gw6': 'test_value_81',
            'localid': 'test_value_82',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'monitor': 'test_value_87',
            'monitor_hold_down_delay': '88',
            'monitor_hold_down_time': 'test_value_89',
            'monitor_hold_down_type': 'immediate',
            'monitor_hold_down_weekday': 'everyday',
            'name': 'default_name_92',
            'nattraversal': 'enable',
            'negotiate_timeout': '94',
            'net_device': 'enable',
            'passive_mode': 'enable',
            'peer': 'test_value_97',
            'peergrp': 'test_value_98',
            'peerid': 'test_value_99',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_102',
            'ppk_secret': 'test_value_103',
            'priority': '104',
            'proposal': 'des-md5',
            'psksecret': 'test_value_106',
            'psksecret_remote': 'test_value_107',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_110',
            'remote_gw6': 'test_value_111',
            'remotegw_ddns': 'test_value_112',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_117',
            'suite_b': 'disable',
            'tunnel_search': 'selectors',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_122',
            'vni': '123',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1_interface.fortios_vpn_ipsec(input_data, fos_instance)

    delete_method_mock.assert_called_with('vpn.ipsec', 'phase1-interface', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_vpn_ipsec_phase1_interface_deletion_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    delete_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    delete_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.delete', return_value=delete_method_result)

    input_data = {
        'username': 'admin',
        'state': 'absent',
        'vpn_ipsec_phase1_interface': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_discovery_forwarder': 'enable',
            'auto_discovery_psk': 'enable',
            'auto_discovery_receiver': 'enable',
            'auto_discovery_sender': 'enable',
            'auto_negotiate': 'enable',
            'banner': 'test_value_18',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_23',
            'default_gw': 'test_value_24',
            'default_gw_priority': '25',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '28',
            'dns_mode': 'manual',
            'domain': 'test_value_30',
            'dpd': 'disable',
            'dpd_retrycount': '32',
            'dpd_retryinterval': 'test_value_33',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'encap_local_gw4': 'test_value_36',
            'encap_local_gw6': 'test_value_37',
            'encap_remote_gw4': 'test_value_38',
            'encap_remote_gw6': 'test_value_39',
            'encapsulation': 'none',
            'encapsulation_address': 'ike',
            'enforce_unique_id': 'disable',
            'exchange_interface_ip': 'enable',
            'exchange_ip_addr4': 'test_value_44',
            'exchange_ip_addr6': 'test_value_45',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '48',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_50',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '53',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_56',
            'ip_version': '4',
            'ipv4_dns_server1': 'test_value_58',
            'ipv4_dns_server2': 'test_value_59',
            'ipv4_dns_server3': 'test_value_60',
            'ipv4_end_ip': 'test_value_61',
            'ipv4_name': 'test_value_62',
            'ipv4_netmask': 'test_value_63',
            'ipv4_split_exclude': 'test_value_64',
            'ipv4_split_include': 'test_value_65',
            'ipv4_start_ip': 'test_value_66',
            'ipv4_wins_server1': 'test_value_67',
            'ipv4_wins_server2': 'test_value_68',
            'ipv6_dns_server1': 'test_value_69',
            'ipv6_dns_server2': 'test_value_70',
            'ipv6_dns_server3': 'test_value_71',
            'ipv6_end_ip': 'test_value_72',
            'ipv6_name': 'test_value_73',
            'ipv6_prefix': '74',
            'ipv6_split_exclude': 'test_value_75',
            'ipv6_split_include': 'test_value_76',
            'ipv6_start_ip': 'test_value_77',
            'keepalive': '78',
            'keylife': '79',
            'local_gw': 'test_value_80',
            'local_gw6': 'test_value_81',
            'localid': 'test_value_82',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'monitor': 'test_value_87',
            'monitor_hold_down_delay': '88',
            'monitor_hold_down_time': 'test_value_89',
            'monitor_hold_down_type': 'immediate',
            'monitor_hold_down_weekday': 'everyday',
            'name': 'default_name_92',
            'nattraversal': 'enable',
            'negotiate_timeout': '94',
            'net_device': 'enable',
            'passive_mode': 'enable',
            'peer': 'test_value_97',
            'peergrp': 'test_value_98',
            'peerid': 'test_value_99',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_102',
            'ppk_secret': 'test_value_103',
            'priority': '104',
            'proposal': 'des-md5',
            'psksecret': 'test_value_106',
            'psksecret_remote': 'test_value_107',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_110',
            'remote_gw6': 'test_value_111',
            'remotegw_ddns': 'test_value_112',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_117',
            'suite_b': 'disable',
            'tunnel_search': 'selectors',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_122',
            'vni': '123',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1_interface.fortios_vpn_ipsec(input_data, fos_instance)

    delete_method_mock.assert_called_with('vpn.ipsec', 'phase1-interface', mkey=ANY, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_vpn_ipsec_phase1_interface_idempotent(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'DELETE', 'http_status': 404}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'vpn_ipsec_phase1_interface': {
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_discovery_forwarder': 'enable',
            'auto_discovery_psk': 'enable',
            'auto_discovery_receiver': 'enable',
            'auto_discovery_sender': 'enable',
            'auto_negotiate': 'enable',
            'banner': 'test_value_18',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_23',
            'default_gw': 'test_value_24',
            'default_gw_priority': '25',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '28',
            'dns_mode': 'manual',
            'domain': 'test_value_30',
            'dpd': 'disable',
            'dpd_retrycount': '32',
            'dpd_retryinterval': 'test_value_33',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'encap_local_gw4': 'test_value_36',
            'encap_local_gw6': 'test_value_37',
            'encap_remote_gw4': 'test_value_38',
            'encap_remote_gw6': 'test_value_39',
            'encapsulation': 'none',
            'encapsulation_address': 'ike',
            'enforce_unique_id': 'disable',
            'exchange_interface_ip': 'enable',
            'exchange_ip_addr4': 'test_value_44',
            'exchange_ip_addr6': 'test_value_45',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '48',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_50',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '53',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_56',
            'ip_version': '4',
            'ipv4_dns_server1': 'test_value_58',
            'ipv4_dns_server2': 'test_value_59',
            'ipv4_dns_server3': 'test_value_60',
            'ipv4_end_ip': 'test_value_61',
            'ipv4_name': 'test_value_62',
            'ipv4_netmask': 'test_value_63',
            'ipv4_split_exclude': 'test_value_64',
            'ipv4_split_include': 'test_value_65',
            'ipv4_start_ip': 'test_value_66',
            'ipv4_wins_server1': 'test_value_67',
            'ipv4_wins_server2': 'test_value_68',
            'ipv6_dns_server1': 'test_value_69',
            'ipv6_dns_server2': 'test_value_70',
            'ipv6_dns_server3': 'test_value_71',
            'ipv6_end_ip': 'test_value_72',
            'ipv6_name': 'test_value_73',
            'ipv6_prefix': '74',
            'ipv6_split_exclude': 'test_value_75',
            'ipv6_split_include': 'test_value_76',
            'ipv6_start_ip': 'test_value_77',
            'keepalive': '78',
            'keylife': '79',
            'local_gw': 'test_value_80',
            'local_gw6': 'test_value_81',
            'localid': 'test_value_82',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'monitor': 'test_value_87',
            'monitor_hold_down_delay': '88',
            'monitor_hold_down_time': 'test_value_89',
            'monitor_hold_down_type': 'immediate',
            'monitor_hold_down_weekday': 'everyday',
            'name': 'default_name_92',
            'nattraversal': 'enable',
            'negotiate_timeout': '94',
            'net_device': 'enable',
            'passive_mode': 'enable',
            'peer': 'test_value_97',
            'peergrp': 'test_value_98',
            'peerid': 'test_value_99',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_102',
            'ppk_secret': 'test_value_103',
            'priority': '104',
            'proposal': 'des-md5',
            'psksecret': 'test_value_106',
            'psksecret_remote': 'test_value_107',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_110',
            'remote_gw6': 'test_value_111',
            'remotegw_ddns': 'test_value_112',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_117',
            'suite_b': 'disable',
            'tunnel_search': 'selectors',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_122',
            'vni': '123',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1_interface.fortios_vpn_ipsec(input_data, fos_instance)

    expected_data = {
        'acct-verify': 'enable',
        'add-gw-route': 'enable',
        'add-route': 'disable',
        'assign-ip': 'disable',
        'assign-ip-from': 'range',
        'authmethod': 'psk',
        'authmethod-remote': 'psk',
        'authpasswd': 'test_value_10',
        'authusr': 'test_value_11',
        'authusrgrp': 'test_value_12',
        'auto-discovery-forwarder': 'enable',
        'auto-discovery-psk': 'enable',
        'auto-discovery-receiver': 'enable',
        'auto-discovery-sender': 'enable',
        'auto-negotiate': 'enable',
        'banner': 'test_value_18',
        'cert-id-validation': 'enable',
        'childless-ike': 'enable',
        'client-auto-negotiate': 'disable',
        'client-keep-alive': 'disable',
        'comments': 'test_value_23',
        'default-gw': 'test_value_24',
        'default-gw-priority': '25',
        'dhgrp': '1',
        'digital-signature-auth': 'enable',
        'distance': '28',
        'dns-mode': 'manual',
        'domain': 'test_value_30',
        'dpd': 'disable',
        'dpd-retrycount': '32',
        'dpd-retryinterval': 'test_value_33',
        'eap': 'enable',
        'eap-identity': 'use-id-payload',
        'encap-local-gw4': 'test_value_36',
        'encap-local-gw6': 'test_value_37',
        'encap-remote-gw4': 'test_value_38',
        'encap-remote-gw6': 'test_value_39',
        'encapsulation': 'none',
        'encapsulation-address': 'ike',
        'enforce-unique-id': 'disable',
        'exchange-interface-ip': 'enable',
        'exchange-ip-addr4': 'test_value_44',
        'exchange-ip-addr6': 'test_value_45',
        'forticlient-enforcement': 'enable',
        'fragmentation': 'enable',
        'fragmentation-mtu': '48',
        'group-authentication': 'enable',
        'group-authentication-secret': 'test_value_50',
        'ha-sync-esp-seqno': 'enable',
        'idle-timeout': 'enable',
        'idle-timeoutinterval': '53',
        'ike-version': '1',
        'include-local-lan': 'disable',
        'interface': 'test_value_56',
        'ip-version': '4',
        'ipv4-dns-server1': 'test_value_58',
        'ipv4-dns-server2': 'test_value_59',
        'ipv4-dns-server3': 'test_value_60',
        'ipv4-end-ip': 'test_value_61',
        'ipv4-name': 'test_value_62',
        'ipv4-netmask': 'test_value_63',
        'ipv4-split-exclude': 'test_value_64',
        'ipv4-split-include': 'test_value_65',
        'ipv4-start-ip': 'test_value_66',
        'ipv4-wins-server1': 'test_value_67',
        'ipv4-wins-server2': 'test_value_68',
        'ipv6-dns-server1': 'test_value_69',
        'ipv6-dns-server2': 'test_value_70',
        'ipv6-dns-server3': 'test_value_71',
        'ipv6-end-ip': 'test_value_72',
        'ipv6-name': 'test_value_73',
        'ipv6-prefix': '74',
        'ipv6-split-exclude': 'test_value_75',
        'ipv6-split-include': 'test_value_76',
        'ipv6-start-ip': 'test_value_77',
        'keepalive': '78',
        'keylife': '79',
        'local-gw': 'test_value_80',
        'local-gw6': 'test_value_81',
        'localid': 'test_value_82',
        'localid-type': 'auto',
        'mesh-selector-type': 'disable',
        'mode': 'aggressive',
                'mode-cfg': 'disable',
                'monitor': 'test_value_87',
                'monitor-hold-down-delay': '88',
                'monitor-hold-down-time': 'test_value_89',
                'monitor-hold-down-type': 'immediate',
                'monitor-hold-down-weekday': 'everyday',
                'name': 'default_name_92',
                'nattraversal': 'enable',
                'negotiate-timeout': '94',
                'net-device': 'enable',
                'passive-mode': 'enable',
                'peer': 'test_value_97',
                'peergrp': 'test_value_98',
                'peerid': 'test_value_99',
                'peertype': 'any',
                'ppk': 'disable',
                'ppk-identity': 'test_value_102',
                'ppk-secret': 'test_value_103',
                'priority': '104',
                'proposal': 'des-md5',
                'psksecret': 'test_value_106',
                'psksecret-remote': 'test_value_107',
                'reauth': 'disable',
                'rekey': 'enable',
                'remote-gw': 'test_value_110',
                'remote-gw6': 'test_value_111',
                'remotegw-ddns': 'test_value_112',
                'rsa-signature-format': 'pkcs1',
                'save-password': 'disable',
                'send-cert-chain': 'enable',
                'signature-hash-alg': 'sha1',
                'split-include-service': 'test_value_117',
                'suite-b': 'disable',
                'tunnel-search': 'selectors',
                'type': 'static',
                'unity-support': 'disable',
                'usrgrp': 'test_value_122',
                'vni': '123',
                'wizard-type': 'custom',
                'xauthtype': 'disable'
    }

    set_method_mock.assert_called_with('vpn.ipsec', 'phase1-interface', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 404


def test_vpn_ipsec_phase1_interface_filter_foreign_attributes(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'vpn_ipsec_phase1_interface': {
            'random_attribute_not_valid': 'tag',
            'acct_verify': 'enable',
            'add_gw_route': 'enable',
            'add_route': 'disable',
            'assign_ip': 'disable',
            'assign_ip_from': 'range',
            'authmethod': 'psk',
            'authmethod_remote': 'psk',
            'authpasswd': 'test_value_10',
            'authusr': 'test_value_11',
            'authusrgrp': 'test_value_12',
            'auto_discovery_forwarder': 'enable',
            'auto_discovery_psk': 'enable',
            'auto_discovery_receiver': 'enable',
            'auto_discovery_sender': 'enable',
            'auto_negotiate': 'enable',
            'banner': 'test_value_18',
            'cert_id_validation': 'enable',
            'childless_ike': 'enable',
            'client_auto_negotiate': 'disable',
            'client_keep_alive': 'disable',
            'comments': 'test_value_23',
            'default_gw': 'test_value_24',
            'default_gw_priority': '25',
            'dhgrp': '1',
            'digital_signature_auth': 'enable',
            'distance': '28',
            'dns_mode': 'manual',
            'domain': 'test_value_30',
            'dpd': 'disable',
            'dpd_retrycount': '32',
            'dpd_retryinterval': 'test_value_33',
            'eap': 'enable',
            'eap_identity': 'use-id-payload',
            'encap_local_gw4': 'test_value_36',
            'encap_local_gw6': 'test_value_37',
            'encap_remote_gw4': 'test_value_38',
            'encap_remote_gw6': 'test_value_39',
            'encapsulation': 'none',
            'encapsulation_address': 'ike',
            'enforce_unique_id': 'disable',
            'exchange_interface_ip': 'enable',
            'exchange_ip_addr4': 'test_value_44',
            'exchange_ip_addr6': 'test_value_45',
            'forticlient_enforcement': 'enable',
            'fragmentation': 'enable',
            'fragmentation_mtu': '48',
            'group_authentication': 'enable',
            'group_authentication_secret': 'test_value_50',
            'ha_sync_esp_seqno': 'enable',
            'idle_timeout': 'enable',
            'idle_timeoutinterval': '53',
            'ike_version': '1',
            'include_local_lan': 'disable',
            'interface': 'test_value_56',
            'ip_version': '4',
            'ipv4_dns_server1': 'test_value_58',
            'ipv4_dns_server2': 'test_value_59',
            'ipv4_dns_server3': 'test_value_60',
            'ipv4_end_ip': 'test_value_61',
            'ipv4_name': 'test_value_62',
            'ipv4_netmask': 'test_value_63',
            'ipv4_split_exclude': 'test_value_64',
            'ipv4_split_include': 'test_value_65',
            'ipv4_start_ip': 'test_value_66',
            'ipv4_wins_server1': 'test_value_67',
            'ipv4_wins_server2': 'test_value_68',
            'ipv6_dns_server1': 'test_value_69',
            'ipv6_dns_server2': 'test_value_70',
            'ipv6_dns_server3': 'test_value_71',
            'ipv6_end_ip': 'test_value_72',
            'ipv6_name': 'test_value_73',
            'ipv6_prefix': '74',
            'ipv6_split_exclude': 'test_value_75',
            'ipv6_split_include': 'test_value_76',
            'ipv6_start_ip': 'test_value_77',
            'keepalive': '78',
            'keylife': '79',
            'local_gw': 'test_value_80',
            'local_gw6': 'test_value_81',
            'localid': 'test_value_82',
            'localid_type': 'auto',
            'mesh_selector_type': 'disable',
            'mode': 'aggressive',
            'mode_cfg': 'disable',
            'monitor': 'test_value_87',
            'monitor_hold_down_delay': '88',
            'monitor_hold_down_time': 'test_value_89',
            'monitor_hold_down_type': 'immediate',
            'monitor_hold_down_weekday': 'everyday',
            'name': 'default_name_92',
            'nattraversal': 'enable',
            'negotiate_timeout': '94',
            'net_device': 'enable',
            'passive_mode': 'enable',
            'peer': 'test_value_97',
            'peergrp': 'test_value_98',
            'peerid': 'test_value_99',
            'peertype': 'any',
            'ppk': 'disable',
            'ppk_identity': 'test_value_102',
            'ppk_secret': 'test_value_103',
            'priority': '104',
            'proposal': 'des-md5',
            'psksecret': 'test_value_106',
            'psksecret_remote': 'test_value_107',
            'reauth': 'disable',
            'rekey': 'enable',
            'remote_gw': 'test_value_110',
            'remote_gw6': 'test_value_111',
            'remotegw_ddns': 'test_value_112',
            'rsa_signature_format': 'pkcs1',
            'save_password': 'disable',
            'send_cert_chain': 'enable',
            'signature_hash_alg': 'sha1',
            'split_include_service': 'test_value_117',
            'suite_b': 'disable',
            'tunnel_search': 'selectors',
            'type': 'static',
            'unity_support': 'disable',
            'usrgrp': 'test_value_122',
            'vni': '123',
            'wizard_type': 'custom',
            'xauthtype': 'disable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_vpn_ipsec_phase1_interface.fortios_vpn_ipsec(input_data, fos_instance)

    expected_data = {
        'acct-verify': 'enable',
        'add-gw-route': 'enable',
        'add-route': 'disable',
        'assign-ip': 'disable',
        'assign-ip-from': 'range',
        'authmethod': 'psk',
        'authmethod-remote': 'psk',
        'authpasswd': 'test_value_10',
        'authusr': 'test_value_11',
        'authusrgrp': 'test_value_12',
        'auto-discovery-forwarder': 'enable',
        'auto-discovery-psk': 'enable',
        'auto-discovery-receiver': 'enable',
        'auto-discovery-sender': 'enable',
        'auto-negotiate': 'enable',
        'banner': 'test_value_18',
        'cert-id-validation': 'enable',
        'childless-ike': 'enable',
        'client-auto-negotiate': 'disable',
        'client-keep-alive': 'disable',
        'comments': 'test_value_23',
        'default-gw': 'test_value_24',
        'default-gw-priority': '25',
        'dhgrp': '1',
        'digital-signature-auth': 'enable',
        'distance': '28',
        'dns-mode': 'manual',
        'domain': 'test_value_30',
        'dpd': 'disable',
        'dpd-retrycount': '32',
        'dpd-retryinterval': 'test_value_33',
        'eap': 'enable',
        'eap-identity': 'use-id-payload',
        'encap-local-gw4': 'test_value_36',
        'encap-local-gw6': 'test_value_37',
        'encap-remote-gw4': 'test_value_38',
        'encap-remote-gw6': 'test_value_39',
        'encapsulation': 'none',
        'encapsulation-address': 'ike',
        'enforce-unique-id': 'disable',
        'exchange-interface-ip': 'enable',
        'exchange-ip-addr4': 'test_value_44',
        'exchange-ip-addr6': 'test_value_45',
        'forticlient-enforcement': 'enable',
        'fragmentation': 'enable',
        'fragmentation-mtu': '48',
        'group-authentication': 'enable',
        'group-authentication-secret': 'test_value_50',
        'ha-sync-esp-seqno': 'enable',
        'idle-timeout': 'enable',
        'idle-timeoutinterval': '53',
        'ike-version': '1',
        'include-local-lan': 'disable',
        'interface': 'test_value_56',
        'ip-version': '4',
        'ipv4-dns-server1': 'test_value_58',
        'ipv4-dns-server2': 'test_value_59',
        'ipv4-dns-server3': 'test_value_60',
        'ipv4-end-ip': 'test_value_61',
        'ipv4-name': 'test_value_62',
        'ipv4-netmask': 'test_value_63',
        'ipv4-split-exclude': 'test_value_64',
        'ipv4-split-include': 'test_value_65',
        'ipv4-start-ip': 'test_value_66',
        'ipv4-wins-server1': 'test_value_67',
        'ipv4-wins-server2': 'test_value_68',
        'ipv6-dns-server1': 'test_value_69',
        'ipv6-dns-server2': 'test_value_70',
        'ipv6-dns-server3': 'test_value_71',
        'ipv6-end-ip': 'test_value_72',
        'ipv6-name': 'test_value_73',
        'ipv6-prefix': '74',
        'ipv6-split-exclude': 'test_value_75',
        'ipv6-split-include': 'test_value_76',
        'ipv6-start-ip': 'test_value_77',
        'keepalive': '78',
        'keylife': '79',
        'local-gw': 'test_value_80',
        'local-gw6': 'test_value_81',
        'localid': 'test_value_82',
        'localid-type': 'auto',
        'mesh-selector-type': 'disable',
        'mode': 'aggressive',
                'mode-cfg': 'disable',
                'monitor': 'test_value_87',
                'monitor-hold-down-delay': '88',
                'monitor-hold-down-time': 'test_value_89',
                'monitor-hold-down-type': 'immediate',
                'monitor-hold-down-weekday': 'everyday',
                'name': 'default_name_92',
                'nattraversal': 'enable',
                'negotiate-timeout': '94',
                'net-device': 'enable',
                'passive-mode': 'enable',
                'peer': 'test_value_97',
                'peergrp': 'test_value_98',
                'peerid': 'test_value_99',
                'peertype': 'any',
                'ppk': 'disable',
                'ppk-identity': 'test_value_102',
                'ppk-secret': 'test_value_103',
                'priority': '104',
                'proposal': 'des-md5',
                'psksecret': 'test_value_106',
                'psksecret-remote': 'test_value_107',
                'reauth': 'disable',
                'rekey': 'enable',
                'remote-gw': 'test_value_110',
                'remote-gw6': 'test_value_111',
                'remotegw-ddns': 'test_value_112',
                'rsa-signature-format': 'pkcs1',
                'save-password': 'disable',
                'send-cert-chain': 'enable',
                'signature-hash-alg': 'sha1',
                'split-include-service': 'test_value_117',
                'suite-b': 'disable',
                'tunnel-search': 'selectors',
                'type': 'static',
                'unity-support': 'disable',
                'usrgrp': 'test_value_122',
                'vni': '123',
                'wizard-type': 'custom',
                'xauthtype': 'disable'
    }

    set_method_mock.assert_called_with('vpn.ipsec', 'phase1-interface', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200
