#!/bin/bash

set -ex

UPSTREAM_VERSION=$(dpkg-parsechangelog -S Version | cut -f 1 -d -)

rm -rf vendor
cargo vendor

# Remove the checksum files to allow us to patch the crates without updating checksums
for crate in vendor/*; do \
	sed -i 's/^{"files":.*"package":"\([a-z0-9]\+\)"}$/{"files":{},"package":"\1"}/' $crate/.cargo-checksum.json; \
done

(
  cd vendor
  tar -czf ../../rpds-py_$UPSTREAM_VERSION.orig-vendor.tar.gz *
)

CARGO_VENDOR_DIR=vendor /usr/share/cargo/bin/dh-cargo-vendored-sources
