"""
Provide a cython implimentation verner 'most-efficient'
order 9 runge-Kutta method.
See https://www.sfu.ca/~jverner/
"""
# Verner 9 Efficient
# https://www.sfu.ca/~jverner/

__all__ = ["vern9_coeff"]
import numpy as np
order = 9
rk_step = 16
rk_extra_step = 26
denseout_order = 9

bh = np.zeros(rk_step, dtype=np.float64)
a = np.zeros((rk_extra_step, rk_extra_step), dtype=np.float64)
b = np.zeros(rk_step, dtype=np.float64)
c = np.zeros(rk_extra_step, dtype=np.float64)
e = np.zeros(rk_step, dtype=np.float64)
bi = np.zeros((rk_extra_step, denseout_order), dtype=np.float64)

c[0] = 0.
c[1] = .3462e-1
c[2] = .9702435063878044594828361677100617517633e-1
c[3] = .1455365259581706689224254251565092627645
c[4] = .561
c[5] = .2290079115904850126662751771814700052182
c[6] = .5449920884095149873337248228185299947818
c[7] = .645
c[8] = .4837500000000000000000000000000000000000
c[9] = .6757e-1
c[10] = .2500
c[11] = .6590650618730998549405331618649220295334
c[12] = .8206
c[13] = .9012
c[14] = 1.
c[15] = 1.

a[1, 0] = .3462e-1

a[2, 0] = -.389335438857287327017042687229284478532e-1
a[2, 1] = .1359578945245091786499878854939346230295

a[3, 0] = .3638413148954266723060635628912731569111e-1
a[3, 1] = 0.
a[3, 2] = .1091523944686280016918190688673819470733

a[4, 0] = 2.025763914393969636805657604282571047511
a[4, 1] = 0.
a[4, 2] = -7.638023836496292020387602153091964592952
a[4, 3] = 6.173259922102322383581944548809393545442

a[5, 0] = .5112275589406060872792270881648288397197e-1
a[5, 1] = 0.
a[5, 2] = 0.
a[5, 3] = .1770823794555021537929910813839068684087
a[5, 4] = .80277624092225014536138698108025283759e-3

a[6, 0] = .1316006357975216279279871693164256985334
a[6, 1] = 0.
a[6, 2] = 0.
a[6, 3] = -.2957276252669636417685183174672273730699
a[6, 4] = .878137803564295237421124704053886667082e-1
a[6, 5] = .6213052975225274774321435005639430026100

a[7, 0] = .7166666666666666666666666666666666666667e-1
a[7, 1] = 0.
a[7, 2] = 0.
a[7, 3] = 0.
a[7, 4] = 0.
a[7, 5] = .3305533578915319409260346730051472207728
a[7, 6] = .2427799754418013924072986603281861125606

a[8, 0] = .7180664062500000000000000000000000000000e-1
a[8, 1] = 0.
a[8, 2] = 0.
a[8, 3] = 0.
a[8, 4] = 0.
a[8, 5] = .3294380283228177160744825466257672816401
a[8, 6] = .1165190029271822839255174533742327183599
a[8, 7] = -.3401367187500000000000000000000000000000e-1

a[9, 0] = .4836757646340646986611287718844085773549e-1
a[9, 1] = 0.
a[9, 2] = 0.
a[9, 3] = 0.
a[9, 4] = 0.
a[9, 5] = .3928989925676163974333190042057047002852e-1
a[9, 6] = .1054740945890344608263649267140088017604
a[9, 7] = -.2143865284648312665982642293830533996214e-1
a[9, 8] = -.1041229174627194437759832813847147895623

a[10, 0] = -.2664561487201478635337289243849737340534e-1
a[10, 1] = 0.
a[10, 2] = 0.
a[10, 3] = 0.
a[10, 4] = 0.
a[10, 5] = .3333333333333333333333333333333333333333e-1
a[10, 6] = -.1631072244872467239162704487554706387141
a[10, 7] = .3396081684127761199487954930015522928244e-1
a[10, 8] = .1572319413814626097110769806810024118077
a[10, 9] = .2152267478031879552303534778794770376960

a[11, 0] = .3689009248708622334786359863227633989718e-1
a[11, 1] = 0.
a[11, 2] = 0.
a[11, 3] = 0.
a[11, 4] = 0.
a[11, 5] = -.1465181576725542928653609891758501156785
a[11, 6] = .2242577768172024345345469822625833796001
a[11, 7] = .2294405717066072637090897902753790803034e-1
a[11, 8] = -.35850052905728761357394424889330334334e-2
a[11, 9] = .8669223316444385506869203619044453906053e-1
a[11, 10] = .4383840651968337846196219974168630120572

a[12, 0] = -.4866012215113340846662212357570395295088
a[12, 1] = 0.
a[12, 2] = 0.
a[12, 3] = 0.
a[12, 4] = 0.
a[12, 5] = -6.304602650282852990657772792012007122988
a[12, 6] = -.281245618289472564778284183790118418111
a[12, 7] = -2.679019236219849057687906597489223155566
a[12, 8] = .518815663924157511565311164615012522024
a[12, 9] = 1.365353187603341710683633635235238678626
a[12, 10] = 5.885091088503946585721274891680604830712
a[12, 11] = 2.802808786272062889819965117517532194812

a[13, 0] = .4185367457753471441471025246471931649633
a[13, 1] = 0.
a[13, 2] = 0.
a[13, 3] = 0.
a[13, 4] = 0.
a[13, 5] = 6.724547581906459363100870806514855026676
a[13, 6] = -.425444280164611790606983409697113064616
a[13, 7] = 3.343279153001265577811816947557982637749
a[13, 8] = .617081663117537759528421117507709784737
a[13, 9] = -.929966123939932833937749523988800852013
a[13, 10] = -6.099948804751010722472962837945508844846
a[13, 11] = -3.002206187889399044804158084895173690015
a[13, 12] = .2553202529443445472336424602988558373637

a[14, 0] = -.779374086122884664644623040843840506343
a[14, 1] = 0.
a[14, 2] = 0.
a[14, 3] = 0.
a[14, 4] = 0.
a[14, 5] = -13.93734253810777678786523664804936051203
a[14, 6] = 1.252048853379357320949735183924200895136
a[14, 7] = -14.69150040801686878191527989293072091588
a[14, 8] = -.494705058533141685655191992136962873577
a[14, 9] = 2.242974909146236657906984549543692874755
a[14, 10] = 13.36789380382864375813864978592679139881
a[14, 11] = 14.39665048665068644512236935340272139005
a[14, 12] = -.7975813331776800379127866056663258667437
a[14, 13] = .4409353709534277758753793068298041158235

a[15, 0] = 2.058051337466886442151242368989994043993
a[15, 1] = 0.
a[15, 2] = 0.
a[15, 3] = 0.
a[15, 4] = 0.
a[15, 5] = 22.35793772796803295519317565842520212899
a[15, 6] = .90949810997556332745009198137971890783
a[15, 7] = 35.89110098240264104710550686568482456493
a[15, 8] = -3.442515027624453437985000403608480262211
a[15, 9] = -4.865481358036368826566013387928704014496
a[15, 10] = -18.90980381354342625688427480879773032857
a[15, 11] = -34.26354448030451782929251177395134170515
a[15, 12] = 1.264756521695642578827783499806516664686
a[15, 13] = 0.
a[15, 14] = 0.

b[0] = .1461197685842315252051541915018784713459e-1
b[1] = 0.
b[2] = 0.
b[3] = 0.
b[4] = 0.
b[5] = 0.
b[6] = 0.
b[7] = -.3915211862331339089410228267288242030810
b[8] = .2310932500289506415909675644868993669908
b[9] = .1274766769992852382560589467488989175618
b[10] = .2246434176204157731566981937082069688984
b[11] = .5684352689748512932705226972873692126743
b[12] = .5825871557215827200814768021863420902155e-1
b[13] = .1364317403482215641609022744494239843327
b[14] = .3057013983082797397721005067920369646664e-1
b[15] = 0.

bh[0] = .1996996514886773085518508418098868756464e-1
bh[1] = 0.
bh[2] = 0.
bh[3] = 0.
bh[4] = 0.
bh[5] = 0.
bh[6] = 0.
bh[7] = 2.191499304949330054530747099310837524864
bh[8] = .8857071848208438030833722031786358862953e-1
bh[9] = .1140560234865965622484956605091432032674
bh[10] = .2533163805345107065564577734569651977347
bh[11] = -2.056564386240941011158999594595981300493
bh[12] = .3408096799013119935160094894224543812830
bh[13] = 0.
bh[14] = 0.
bh[15] = .4834231373823958314376726739772871714902e-1

for i in range(16):
    e[i] = b[i] - bh[i]

c[16] = 1.0

a[16, 0] = .1461197685842315252051541915018784713459e-1
a[16, 1] = 0.
a[16, 2] = 0.
a[16, 3] = 0.
a[16, 4] = 0.
a[16, 5] = 0.
a[16, 6] = 0.
a[16, 7] = -.3915211862331339089410228267288242030810
a[16, 8] = .2310932500289506415909675644868993669908
a[16, 9] = .1274766769992852382560589467488989175618
a[16, 10] = .2246434176204157731566981937082069688984
a[16, 11] = .5684352689748512932705226972873692126743
a[16, 12] = .5825871557215827200814768021863420902155e-1
a[16, 13] = .1364317403482215641609022744494239843327
a[16, 14] = .3057013983082797397721005067920369646664e-1
a[16, 15] = 0.

c[17] = .7404185470631561083004100761798676215811

a[17, 0] = .1549973668189559302279946863304789372788e-1
a[17, 1] = 0.
a[17, 2] = 0.
a[17, 3] = 0.
a[17, 4] = 0.
a[17, 5] = 0.
a[17, 6] = 0.
a[17, 7] = .3355153219059635054403439303177105512242
a[17, 8] = .2003613944191860651552622660712101217322
a[17, 9] = .1252060659283549312946162355194540994211
a[17, 10] = .2298676393184206750544046308957155868736
a[17, 11] = -.2020250653476181447824906889122391003637
a[17, 12] = .5917103230665456601422111997583025339897e-1
a[17, 13] = -.2651834783047638681693835956996437528251e-1
a[17, 14] = -.2384094602130971415278110567256446033405e-1
a[17, 15] = 0.
a[17, 16] = .2718171570208501807097257892166705118335e-1

c[18] = .888

a[18, 0] = .1302453943114338366054520296881099431474e-1
a[18, 1] = 0.
a[18, 2] = 0.
a[18, 3] = 0.
a[18, 4] = 0.
a[18, 5] = 0.
a[18, 6] = 0.
a[18, 7] = -.7452850902413112085299330666038981625179
a[18, 8] = .2643867896429300961465132150322749722129
a[18, 9] = .1313961758372753932588328082078842388890
a[18, 10] = .2167253815122927263092467187957410643315
a[18, 11] = .8734117564076052559016338094938888451419
a[18, 12] = .1185905643935776688228545787724340848142e-1
a[18, 13] = .5876002941689550612992712203494447529933e-1
a[18, 14] = .3266518630202087866399279690939423159022e-2
a[18, 15] = 0.
a[18, 16] = -.8959308648417929824525368306101792182274e-2
a[18, 17] = .6941415157202692219907482080827253287034e-1

c[19] = .696

a[19, 0] = .1397089996925942721283716334050740168797e-1
a[19, 1] = 0.
a[19, 2] = 0.
a[19, 3] = 0.
a[19, 4] = 0.
a[19, 5] = 0.
a[19, 6] = 0.
a[19, 7] = -.4665765335957674596054673402956853940520
a[19, 8] = .2416372787216257077935214889875485248580
a[19, 9] = .1290363341345674735721677437066933999929
a[19, 10] = .2216700671735105311080225734522323922813
a[19, 11] = .6257275123364644931771253383573999863003
a[19, 12] = .4355312415679284117869124964829805160429e-1
a[19, 13] = .1011962491667290833450024852274278874501
a[19, 14] = .1808582254679721049279369742685497400353e-1
a[19, 15] = 0.
a[19, 16] = -.2079875587689169691156509689282083267654e-1
a[19, 17] = -.9022232517086218976198252891464664868640e-1
a[19, 18] = -.1212796735622254216011467740438097427634

c[20] = .487

a[20, 0] = .1604638888318112738641232352800290501904e-1
a[20, 1] = 0.
a[20, 2] = 0.
a[20, 3] = 0.
a[20, 4] = 0.
a[20, 5] = 0.
a[20, 6] = 0.
a[20, 7] = .9517712399458336651642257453589397190702e-1
a[20, 8] = .1359187264655317806136927180199100622471
a[20, 9] = .1237765280959854006935081364365637515893
a[20, 10] = .2335656264102966047058755123098072346246
a[20, 11] = -.9051508172625873314662090873741762206189e-1
a[20, 12] = -.2537574270006131028513276914038326155331e-1
a[20, 13] = -.1359631696887162048002744757083947500478
a[20, 14] = -.4679214284145113075088049469061349990847e-1
a[20, 15] = 0.
a[20, 16] = .5177958859391748239949773879090325427473e-1
a[20, 17] = .9672595677476773313884172931875718705561e-1
a[20, 18] = .1477312690340742769720989417101989769314
a[20, 19] = -.1150750712958503934434410263732282100773
c[21] = .25e-1

a[21, 0] = .1802918623893620731908165792176564180038e-1
a[21, 1] = 0.
a[21, 2] = 0.
a[21, 3] = 0.
a[21, 4] = 0.
a[21, 5] = 0.
a[21, 6] = 0.
a[21, 7] = .6983601042028873702545973390560096201728e-1
a[21, 8] = -.2541247660791663512384395986842781657182e-1
a[21, 9] = .8487827035463274491721441398893680307535e-2
a[21, 10] = -.2427525516089801645451101966852425715128e-2
a[21, 11] = -.1047839752893819879012607694745789515746
a[21, 12] = -.1473147795248041942353840372690095884761e-1
a[21, 13] = -.3916338390816177165706892282751065537530e-1
a[21, 14] = -.1005657343293959419073236542225421561652e-1
a[21, 15] = 0.
a[21, 16] = .1102510392204834322538452331445716455061e-1
a[21, 17] = .5092830749095398308703438556315975226108e-2
a[21, 18] = .4759715599420644505591133410826632557391e-1
a[21, 19] = .3386307003288382751110965442296681690349e-1
a[21, 20] = .2764422831404797700452373965825845732168e-1

c[22] = .15

a[22, 0] = .1677431640522778042988664067637191163626e-1
a[22, 1] = 0.
a[22, 2] = 0.
a[22, 3] = 0.
a[22, 4] = 0.
a[22, 5] = 0.
a[22, 6] = 0.
a[22, 7] = .6220437408820475326702539861577894278533
a[22, 8] = -.2060859809768841878234097076241307428139
a[22, 9] = .1156394989766058889629372195583391792474
a[22, 10] = .2664101793378358946544219293685167025971e-1
a[22, 11] = -.9376810793418770527505892794460093668860
a[22, 12] = -.1367806466702160302637074581619101741312
a[22, 13] = -.3678480995268296672182605288991379118419
a[22, 14] = -.9547871314402478902820445838193201497337e-1
a[22, 15] = 0.
a[22, 16] = .1013492018422369748729008873270013785313
a[22, 17] = -.8911323084568593396468400926074881389560e-1
a[22, 18] = .4664140988974760478895528270623735057521
a[22, 19] = .4502736292354579812232681662308722738519
a[22, 20] = .1838522463326818655346135218242696774099
a[22, 21] = 0.

c[23] = .32

a[23, 0] = .1071149731491444187554380927165768658192e-1
a[23, 1] = 0.
a[23, 2] = 0.
a[23, 3] = 0.
a[23, 4] = 0.
a[23, 5] = 0.
a[23, 6] = 0.
a[23, 7] = -.7094336118221108191937165464264324417735e-1
a[23, 8] = .1002164900340091596740582334112699697590
a[23, 9] = .1383453980468025108839271214703390659581
a[23, 10] = .1796330633578163411338104055485109917477
a[23, 11] = .9048246545576180974879274948815422276563e-1
a[23, 12] = -.5460662294523338383345981122023862069115e-2
a[23, 13] = -.3000457905119619782973021046143166498567e-1
a[23, 14] = -.1145192026962799093665613252151017277867e-1
a[23, 15] = 0.
a[23, 16] = .1003394686109385076849515422360600302176e-1
a[23, 17] = -.9506485282809046129031027932806241113157e-1
a[23, 18] = .4853358804093591445756711642658478691640e-1
a[23, 19] = .8013325919783924638483373011297347396327e-1
a[23, 20] = -.1251643326835242045676140618774248455713
a[23, 21] = 0.
a[23, 22] = 0.

c[24] = .78

a[24, 0] = .1410172088869221367153586187761994182069e-1
a[24, 1] = 0.
a[24, 2] = 0.
a[24, 3] = 0.
a[24, 4] = 0.
a[24, 5] = 0.
a[24, 6] = 0.
a[24, 7] = -.3713379753704491105936205420001801316029
a[24, 8] = .2231265548117180273161442520179150684520
a[24, 9] = .1287005345918120122888629169443916280865
a[24, 10] = .2224600659675494761192249831098918110654
a[24, 11] = .5382853042550701952740528638168708946100
a[24, 12] = .5417202616988763101781128062036252796548e-1
a[24, 13] = .1256968791308743925752109039299467082975
a[24, 14] = .2784492789002054061504430663197543089132e-1
a[24, 15] = 0.
a[24, 16] = -.3077409246205059733390460511525401688205e-1
a[24, 17] = .8569805293689777608077303071761466118035e-2
a[24, 18] = -.1535174690587044615794997685221990516897
a[24, 19] = -.2179957030548196497189489878038029238243e-1
a[24, 20] = .1447128819737186799295514239727801525027e-1
a[24, 21] = 0.
a[24, 22] = 0.
a[24, 23] = 0.

c[25] = .96

a[25, 0] = .1424600411735646609296566581447532773183e-1
a[25, 1] = 0.
a[25, 2] = 0.
a[25, 3] = 0.
a[25, 4] = 0.
a[25, 5] = 0.
a[25, 6] = 0.
a[25, 7] = -.3767107393295407091303982522049390741260
a[25, 8] = .2252399780730421480874737297000189000070
a[25, 9] = .1283603076292529988314451246143633426068
a[25, 10] = .2230238705261692544876826347415151339678
a[25, 11] = .5463127827750747224899202176094949607118
a[25, 12] = .5526190791375779994553849469706124289752e-1
a[25, 13] = .1285613508749982456581494397108686240388
a[25, 14] = .2857250681296406482698934635829147899039e-1
a[25, 15] = 0.
a[25, 16] = -.2398761886357108720930416967644499057175e-1
a[25, 17] = .5556224458910509454379297181908734648749e-1
a[25, 18] = -.1740675650762838674257930398070760254668e-1
a[25, 19] = -.3815462365996979065575121886854199471011e-1
a[25, 20] = .1111878504898917877407531966545730451506e-1
a[25, 21] = 0.
a[25, 22] = 0.
a[25, 23] = 0.
a[25, 24] = 0.

bi[0, 0] = 1.
bi[0, 1] = -28.33048870061739823290767301658881994700
bi[0, 2] = 257.6535452078577977252092979905248156497
bi[0, 3] = -1152.154455743457311528752964691951881858
bi[0, 4] = 2909.390878345408890936564599116550031880
bi[0, 5] = -4355.005172868188498048946108887283528629
bi[0, 6] = 3834.083497036262189455855371796461857871
bi[0, 7] = -1835.419052683407081215583427992189311730
bi[0, 8] = 368.7958613829998340610814211036270246107

bi[1, 0] = 0.
bi[1, 1] = 0.
bi[1, 2] = 0.
bi[1, 3] = 0.
bi[1, 4] = 0.
bi[1, 5] = 0.
bi[1, 6] = 0.
bi[1, 7] = 0.
bi[1, 8] = 0.

bi[2, 0] = 0.
bi[2, 1] = 0.
bi[2, 2] = 0.
bi[2, 3] = 0.
bi[2, 4] = 0.
bi[2, 5] = 0.
bi[2, 6] = 0.
bi[2, 7] = 0.
bi[2, 8] = 0.

bi[3, 0] = 0.
bi[3, 1] = 0.
bi[3, 2] = 0.
bi[3, 3] = 0.
bi[3, 4] = 0.
bi[3, 5] = 0.
bi[3, 6] = 0.
bi[3, 7] = 0.
bi[3, 8] = 0.

bi[4, 0] = 0.
bi[4, 1] = 0.
bi[4, 2] = 0.
bi[4, 3] = 0.
bi[4, 4] = 0.
bi[4, 5] = 0.
bi[4, 6] = 0.
bi[4, 7] = 0.
bi[4, 8] = 0.

bi[5, 0] = 0.
bi[5, 1] = 0.
bi[5, 2] = 0.
bi[5, 3] = 0.
bi[5, 4] = 0.
bi[5, 5] = 0.
bi[5, 6] = 0.
bi[5, 7] = 0.
bi[5, 8] = 0.

bi[6, 0] = 0.
bi[6, 1] = 0.
bi[6, 2] = 0.
bi[6, 3] = 0.
bi[6, 4] = 0.
bi[6, 5] = 0.
bi[6, 6] = 0.
bi[6, 7] = 0.
bi[6, 8] = 0.

bi[7, 0] = 0.
bi[7, 1] = 2.649656243770091212685381903551424676261
bi[7, 2] = -96.30312807816005963630382777245983513008
bi[7, 3] = 869.3095462492795755338599928089438369769
bi[7, 4] = -3395.688567551074115525201961265641584358
bi[7, 5] = 6796.933987158715680563278170147156885480
bi[7, 6] = -7340.848417712071304684606060804637321789
bi[7, 7] = 4082.848896992365666259441580054990759905
bi[7, 8] = -919.2934944890586676320942978986329899642

bi[8, 0] = 0.
bi[8, 1] = -1.563945181928732780647121505551017046606
bi[8, 2] = 56.84239739272860000194549791973820565214
bi[8, 3] = -513.1052300304284642178552372517916694426
bi[8, 4] = 2004.286702110323162741493515173880535381
bi[8, 5] = -4011.853305913929339500285683507736138334
bi[8, 6] = 4332.895839278586189971336003691596594090
bi[8, 7] = -2409.879347937144606091337260195738587773
bi[8, 8] = 542.6079835318221405169412532400889768401

bi[9, 0] = 0.
bi[9, 1] = -.8627103334967223830653368770735555216700
bi[9, 2] = 31.35565375185173442495465167501846267906
bi[9, 3] = -283.0413682227354209126847112083546012674
bi[9, 4] = 1105.613463426006937052739159664962261462
bi[9, 5] = -2213.036200678452629288185991597653042989
bi[9, 6] = 2390.131097754120588994847482867886207858
bi[9, 7] = -1329.348266146873716496636094950745123424
bi[9, 8] = 299.3158071265785138462868993727082901209

bi[10, 0] = 0.
bi[10, 1] = -1.520295337901214839055193576160469820911
bi[10, 2] = 55.25592121120227100440616045452813504748
bi[10, 3] = -498.7844190970740738969945498750124435385
bi[10, 4] = 1948.346888525776056658403461666308795237
bi[10, 5] = -3899.882136407551390287649940376076923682
bi[10, 6] = 4211.964345158858030803618536151121927765
bi[10, 7] = -2342.619408856117128087568672414857706561
bi[10, 8] = 527.4637482204278644179968961638568925209

bi[11, 0] = 0.
bi[11, 1] = -3.846938844125523400516071820264700141179
bi[11, 2] = 139.8189840986840520353362018994734906611
bi[11, 3] = -1262.118687621600386514715930156791825893
bi[11, 4] = 4930.075848057311658057235318456802793199
bi[11, 5] = -9868.219486069539059368988308801366826185
bi[11, 6] = 10657.90892434886730229746304583865145121
bi[11, 7] = -5927.738759872814112912292792695856187255
bi[11, 8] = 1334.688551172190921099749059976639173619

bi[12, 0] = 0.
bi[12, 1] = -.3942713061200141454309326713125653612517
bi[12, 2] = 14.32999476067649707020689155180345562459
bi[12, 3] = -129.3540665994558117853022852051786116929
bi[12, 4] = 505.2816077002517600897861155496606850457
bi[12, 5] = -1011.390080139433268878243655218566636574
bi[12, 6] = 1092.325051781891697669369143688906543465
bi[12, 7] = -607.5317019302810290917918493845279272648
bi[12, 8] = 136.7917244480423273434147193694336909663

bi[13, 0] = 0.
bi[13, 1] = -.9233145622082101394378429409444333268499
bi[13, 2] = 33.55834582309798808260613735851232640640
bi[13, 3] = -302.9246397549735936661321348695774835448
bi[13, 4] = 1183.281306967867553342903125095128753568
bi[13, 5] = -2368.498986790111516106072390247333149007
bi[13, 6] = 2558.034559755808027369106332027405169828
bi[13, 7] = -1422.733175577880214903071122439856598476
bi[13, 8] = 320.3423358787481875842587982911148385364

bi[14, 0] = 0.
bi[14, 1] = -.2068862802930053801253649628830330891017
bi[14, 2] = 7.519388975651662772174695012120581518594
bi[14, 3] = -67.87605708082904058354114755731111898667
bi[14, 4] = 265.1367996984150421661637988925923843021
bi[14, 5] = -530.7074807559025368587558119659212235622
bi[14, 6] = 573.1765495641490277116961329189087439579
bi[14, 7] = -318.7905688834868978004500126002971837241
bi[14, 8] = 71.77882490212657594681492031347005327988

bi[15, 0] = 0.
bi[15, 1] = 0.
bi[15, 2] = 0.
bi[15, 3] = 0.
bi[15, 4] = 0.
bi[15, 5] = 0.
bi[15, 6] = 0.
bi[15, 7] = 0.
bi[15, 8] = 0.

bi[16, 0] = 0.
bi[16, 1] = -.4472441906744099441704338175964823026105
bi[16, 2] = 16.44684676010503791623763886833381020592
bi[16, 3] = -154.4086105921295528355180056633078150675
bi[16, 4] = 641.8986298540248497333509289273669726482
bi[16, 5] = -1391.939225687982391028602609567895699003
bi[16, 6] = 1643.890568302952013019278202625162156841
bi[16, 7] = -1004.065297223317845596795060426393517046
bi[16, 8] = 248.6243327770222987362193390543305737239

bi[17, 0] = 0.
bi[17, 1] = -.1507876007899797948720901584434839156279
bi[17, 2] = 5.527328824824632235316362126620825363280
bi[17, 3] = -51.33833743084618751433903968701557585387
bi[17, 4] = 209.6022002703280347991393999433060881829
bi[17, 5] = -442.7692650421825928714839983614217797969
bi[17, 6] = 505.0579312588052893780948070449787925777
bi[17, 7] = -295.6336410615619366143935619944592839974
bi[17, 8] = 69.70457078142274038253812108643441743987

bi[18, 0] = 0.
bi[18, 1] = -.6413652207435296452288504944964177537185
bi[18, 2] = 23.51013248624684600263471193689787394701
bi[18, 3] = -218.3642683246972281497485359238725613162
bi[18, 4] = 891.5292818535365634586829868055833114383
bi[18, 5] = -1883.290177206007885518558760085145850658
bi[18, 6] = 2148.230954488399755970660772306573864434
bi[18, 7] = -1257.458401521712336970840850120592935471
bi[18, 8] = 296.4838434449778148523985255750527153802

bi[19, 0] = 0.
bi[19, 1] = 1.810729313444845732964058528284532356045
bi[19, 2] = -66.37479657295337371220255196726289169374
bi[19, 3] = 616.4952025401106511929691356878863855003
bi[19, 4] = -2517.003030777322559684753470471663859295
bi[19, 5] = 5316.984175781033401491488704359579721604
bi[19, 6] = -6064.976140789574108556866601189158423779
bi[19, 7] = 3550.109538888391317555902194852386816092
bi[19, 8] = -837.0456783831301740195014698000522807852

bi[20, 0] = 0.
bi[20, 1] = .5176008760353717918864555990277480363987e-1
bi[20, 2] = -1.897337862580348756406065418550014243949
bi[20, 3] = 17.62264820793629244181715147639285955422
bi[20, 4] = -71.94907400242465946110661282550878163878
bi[20, 5] = 151.9871383765666045085018751235590550206
bi[20, 6] = -173.3686498747860565970136435029707518663
bi[20, 7] = 101.4806461521468075879782291473158292931
bi[20, 8] = -23.92713108446217690295957956014097092250

bi[21, 0] = 0.
bi[21, 1] = 31.32178255668799909977422939838912846070
bi[21, 2] = -355.6570858339106059687054319211280026146
bi[21, 3] = 1752.685282489515979253875884672206842255
bi[21, 4] = -4708.092293138363367969732154806019707156
bi[21, 5] = 7370.900776193488713149861391844801840850
bi[21, 6] = -6716.504964764565347011489385051202629762
bi[21, 7] = 3303.940398161185772296756776169088470785
bi[21, 8] = -678.5938956640391428503413103061359428182

bi[22, 0] = 0.
bi[22, 1] = -2.719607334185924760747802644504744092917
bi[22, 2] = 86.64045615858264001154848875638486632034
bi[22, 3] = -454.1926030939030807863651114984001402596
bi[22, 4] = 1014.749221100543425314268817989377200147
bi[22, 5] = -1133.583456714543865890388885909333783663
bi[22, 6] = 610.4671827718666569168001429679645990946
bi[22, 7] = -109.0233499449543802317396567002119357593
bi[22, 8] = -12.33784294340547057337599296127606178639

bi[23, 0] = 0.
bi[23, 1] = 3.177214801432923432265738869490200556403
bi[23, 2] = -113.8098697715142983214434051918276259885
bi[23, 3] = 978.0935981825675014833003847211971070224
bi[23, 4] = -3575.129377623670076451027372711378100786
bi[23, 5] = 6764.361519838450570830405988615992045681
bi[23, 6] = -6987.161043852012362644872233028628887679
bi[23, 7] = 3751.905762789571137088934326513342858381
bi[23, 8] = -821.4378043648253954175634277881875971878

bi[24, 0] = 0.
bi[24, 1] = .8772843083465530069477626269697233842708
bi[24, 2] = -31.51810423988375104361582759389916060143
bi[24, 3] = 273.1229151353221133842213845530391043248
bi[24, 4] = -993.2198643101781966584366870874238565290
bi[24, 5] = 1787.888078312663987193988385659681964836
bi[24, 6] = -1677.394835799640950953367739332661886275
bi[24, 7] = 781.3579535062687952504707744453846824540
bi[24, 8] = -141.1134269128985501802080532710905715931

bi[25, 0] = 0.
bi[25, 1] = 1.719427581798715782378897599231938082126
bi[25, 2] = -62.89867309250732184389962568482931880335
bi[25, 3] = 580.3335507873980391019057196688995930872
bi[25, 4] = -2348.110620506760958600472968113883922730
bi[25, 5] = 4921.119298612906015908637628774963068611
bi[25, 6] = -5597.912448707916639109910311016358007839
bi[25, 7] = 3288.597775149621789973016480733216881572
bi[25, 8] = -782.8483098245396412116558219612402319811

vern9_coeff = {'order': order, 'a': a, 'b': b, 'c': c, 'e': e, 'bi': bi}
