#!/usr/bin/perl -w

BEGIN { unshift @INC, 'lib', '../lib'}
use Chart::Composite;
use File::Temp 0.19;
my $samples = File::Temp->newdir();

print "1..1\n";

$g = Chart::Composite->new( 750, 600 );

$g->add_dataset( 1,   2,   3 );
$g->add_dataset( 10,  20,  30 );
$g->add_dataset( 15,  25,  32 );
$g->add_dataset( 7,   24,  23 );
$g->add_dataset( 0.1, 0.5, 0.9 );

$g->set(
    'title'          => 'Composite Chart Test 2',
    'composite_info' => [ [ 'Bars', [ 1 .. 3 ] ], [ 'LinesPoints', [4] ] ]
);

$g->png("$samples/composite_5.png");

print "ok 1\n";

exit(0);

