# Copyright (C) 2014-2018 Enzien Audio, Ltd.
# Copyright (C) 2023-2024 Wasted Audio
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from hvcc.types.compiler import CompilerNotif


class HeavyException(Exception):
    """ This exception is raised if anything goes wrong during the hv2ir compilation process.
    """

    def __init__(self, message: str = "") -> None:
        super(Exception, self).__init__(message)
        self.message = message
        self.notes: CompilerNotif = CompilerNotif()
