set(include_dirs_python
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/extern>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/extern/filereader>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/extern/pdqsort>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/extern/zstr>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/interfaces>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/io>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/ipm>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/ipm/ipx>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/ipm/basiclu>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/lp_data>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/mip>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/model>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/parallel>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/pdlp>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/pdlp/cupdlp>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/presolve>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/qpsolver>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/simplex>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/test_kkt>
    $<BUILD_INTERFACE:${PROJECT_SOURCE_DIR}/highs/util>
    $<BUILD_INTERFACE:${HIGHS_BINARY_DIR}>)

set(cupdlp_sources_python
  highs/pdlp/cupdlp/cupdlp_cs.c
  highs/pdlp/cupdlp/cupdlp_linalg.c
  highs/pdlp/cupdlp/cupdlp_proj.c
  highs/pdlp/cupdlp/cupdlp_restart.c
  highs/pdlp/cupdlp/cupdlp_scaling.c
  highs/pdlp/cupdlp/cupdlp_solver.c
  highs/pdlp/cupdlp/cupdlp_step.c
  highs/pdlp/cupdlp/cupdlp_utils.c)

set(cupdlp_headers_python
  highs/pdlp/cupdlp/cupdlp_cs.h
  highs/pdlp/cupdlp/cupdlp_defs.h
  highs/pdlp/cupdlp/cupdlp_linalg.h
  highs/pdlp/cupdlp/cupdlp_proj.h
  highs/pdlp/cupdlp/cupdlp_restart.h
  highs/pdlp/cupdlp/cupdlp_scaling.h
  highs/pdlp/cupdlp/cupdlp_solver.h
  highs/pdlp/cupdlp/cupdlp_step.h
  highs/pdlp/cupdlp/cupdlp_utils.c)

set(cuda_sources_python
  pdlp/cupdlp/cuda/cupdlp_cuda_kernels.cu
  pdlp/cupdlp/cuda/cupdlp_cuda_kernels.cuh
  pdlp/cupdlp/cuda/cupdlp_cudalinalg.cuh
  pdlp/cupdlp/cuda/cupdlp_cudalinalg.cu)

set(basiclu_sources_python
  highs/ipm/basiclu/basiclu_factorize.c
  highs/ipm/basiclu/basiclu_get_factors.c
  highs/ipm/basiclu/basiclu_initialize.c
  highs/ipm/basiclu/basiclu_object.c
  highs/ipm/basiclu/basiclu_solve_dense.c
  highs/ipm/basiclu/basiclu_solve_for_update.c
  highs/ipm/basiclu/basiclu_solve_sparse.c
  highs/ipm/basiclu/basiclu_update.c
  highs/ipm/basiclu/lu_build_factors.c
  highs/ipm/basiclu/lu_condest.c
  highs/ipm/basiclu/lu_dfs.c
  highs/ipm/basiclu/lu_factorize_bump.c
  highs/ipm/basiclu/lu_file.c
  highs/ipm/basiclu/lu_garbage_perm.c
  highs/ipm/basiclu/lu_initialize.c
  highs/ipm/basiclu/lu_internal.c
  highs/ipm/basiclu/lu_markowitz.c
  highs/ipm/basiclu/lu_matrix_norm.c
  highs/ipm/basiclu/lu_pivot.c
  highs/ipm/basiclu/lu_residual_test.c
  highs/ipm/basiclu/lu_setup_bump.c
  highs/ipm/basiclu/lu_singletons.c
  highs/ipm/basiclu/lu_solve_dense.c
  highs/ipm/basiclu/lu_solve_for_update.c
  highs/ipm/basiclu/lu_solve_sparse.c
  highs/ipm/basiclu/lu_solve_symbolic.c
  highs/ipm/basiclu/lu_solve_triangular.c
  highs/ipm/basiclu/lu_update.c)

set(basiclu_headers_python
  highs/ipm/basiclu/basiclu_factorize.h
  highs/ipm/basiclu/basiclu_get_factors.h
  highs/ipm/basiclu/basiclu_initialize.h
  highs/ipm/basiclu/basiclu_obj_factorize.h
  highs/ipm/basiclu/basiclu_obj_free.h
  highs/ipm/basiclu/basiclu_obj_get_factors.h
  highs/ipm/basiclu/basiclu_obj_initialize.h
  highs/ipm/basiclu/basiclu_obj_solve_dense.h
  highs/ipm/basiclu/basiclu_obj_solve_for_update.h
  highs/ipm/basiclu/basiclu_obj_solve_sparse.h
  highs/ipm/basiclu/basiclu_obj_update.h
  highs/ipm/basiclu/basiclu_object.h
  highs/ipm/basiclu/basiclu_solve_dense.h
  highs/ipm/basiclu/basiclu_solve_for_update.h
  highs/ipm/basiclu/basiclu_solve_sparse.h
  highs/ipm/basiclu/basiclu_update.h
  highs/ipm/basiclu/basiclu.h
  highs/ipm/basiclu/lu_def.h
  highs/ipm/basiclu/lu_file.h
  highs/ipm/basiclu/lu_internal.h
  highs/ipm/basiclu/lu_list.h)

set(ipx_sources_python
  highs/ipm/ipx/basiclu_kernel.cc
  highs/ipm/ipx/basiclu_wrapper.cc
  highs/ipm/ipx/basis.cc
  highs/ipm/ipx/conjugate_residuals.cc
  highs/ipm/ipx/control.cc
  highs/ipm/ipx/crossover.cc
  highs/ipm/ipx/diagonal_precond.cc
  highs/ipm/ipx/forrest_tomlin.cc
  highs/ipm/ipx/guess_basis.cc
  highs/ipm/ipx/indexed_vector.cc
  highs/ipm/ipx/info.cc
  highs/ipm/ipx/ipm.cc
  highs/ipm/ipx/ipx_c.cc
  highs/ipm/ipx/iterate.cc
  highs/ipm/ipx/kkt_solver_basis.cc
  highs/ipm/ipx/kkt_solver_diag.cc
  highs/ipm/ipx/kkt_solver.cc
  highs/ipm/ipx/linear_operator.cc
  highs/ipm/ipx/lp_solver.cc
  highs/ipm/ipx/lu_factorization.cc
  highs/ipm/ipx/lu_update.cc
  highs/ipm/ipx/maxvolume.cc
  highs/ipm/ipx/model.cc
  highs/ipm/ipx/normal_matrix.cc
  highs/ipm/ipx/sparse_matrix.cc
  highs/ipm/ipx/sparse_utils.cc
  highs/ipm/ipx/splitted_normal_matrix.cc
  highs/ipm/ipx/starting_basis.cc
  highs/ipm/ipx/symbolic_invert.cc
  highs/ipm/ipx/timer.cc
  highs/ipm/ipx/utils.cc)
  
  set(ipx_headers_python
  highs/ipm/ipx/basiclu_kernel.h
  highs/ipm/ipx/basiclu_wrapper.h
  highs/ipm/ipx/basis.h
  highs/ipm/ipx/conjugate_residuals.h
  highs/ipm/ipx/control.h
  highs/ipm/ipx/crossover.h
  highs/ipm/ipx/diagonal_precond.h
  highs/ipm/ipx/forrest_tomlin.h
  highs/ipm/ipx/guess_basis.h
  highs/ipm/ipx/indexed_vector.h
  highs/ipm/ipx/info.h
  highs/ipm/ipx/ipm.h
  highs/ipm/ipx/ipx_c.h
  highs/ipm/ipx/ipx_config.h
  highs/ipm/ipx/ipx_info.h
  highs/ipm/ipx/ipx_internal.h
  highs/ipm/ipx/ipx_parameters.h
  highs/ipm/ipx/ipx_status.h
  highs/ipm/ipx/iterate.h
  highs/ipm/ipx/kkt_solver_basis.h
  highs/ipm/ipx/kkt_solver_diag.h
  highs/ipm/ipx/kkt_solver.h
  highs/ipm/ipx/linear_operator.h
  highs/ipm/ipx/lp_solver.h
  highs/ipm/ipx/lu_factorization.h
  highs/ipm/ipx/lu_update.h
  highs/ipm/ipx/maxvolume.h
  highs/ipm/ipx/model.h
  highs/ipm/ipx/multistream.h
  highs/ipm/ipx/normal_matrix.h
  highs/ipm/ipx/power_method.h
  highs/ipm/ipx/sparse_matrix.h
  highs/ipm/ipx/sparse_utils.h
  highs/ipm/ipx/splitted_normal_matrix.h
  highs/ipm/ipx/starting_basis.h
  highs/ipm/ipx/symbolic_invert.h
  highs/ipm/ipx/timer.h
  highs/ipm/ipx/utils.h)

set(highs_sources_python
    extern/filereaderlp/reader.cpp
    highs/interfaces/highs_c_api.cpp
    highs/io/Filereader.cpp
    highs/io/FilereaderEms.cpp
    highs/io/FilereaderLp.cpp
    highs/io/FilereaderMps.cpp
    highs/io/HighsIO.cpp
    highs/io/HMpsFF.cpp
    highs/io/HMPSIO.cpp
    highs/io/LoadOptions.cpp
    highs/ipm/IpxWrapper.cpp
    highs/lp_data/Highs.cpp
    highs/lp_data/HighsCallback.cpp
    highs/lp_data/HighsDebug.cpp
    highs/lp_data/HighsIis.cpp
    highs/lp_data/HighsInfo.cpp
    highs/lp_data/HighsInfoDebug.cpp
    highs/lp_data/HighsInterface.cpp
    highs/lp_data/HighsLp.cpp
    highs/lp_data/HighsLpUtils.cpp
    highs/lp_data/HighsModelUtils.cpp
    highs/lp_data/HighsOptions.cpp
    highs/lp_data/HighsRanging.cpp
    highs/lp_data/HighsSolution.cpp
    highs/lp_data/HighsSolutionDebug.cpp
    highs/lp_data/HighsSolve.cpp
    highs/lp_data/HighsStatus.cpp
    highs/mip/HighsCliqueTable.cpp
    highs/mip/HighsConflictPool.cpp
    highs/mip/HighsCutGeneration.cpp
    highs/mip/HighsCutPool.cpp
    highs/mip/HighsDebugSol.cpp
    highs/mip/HighsDomain.cpp
    highs/mip/HighsDynamicRowMatrix.cpp
    highs/mip/HighsFeasibilityJump.cpp
    highs/mip/HighsGFkSolve.cpp
    highs/mip/HighsImplications.cpp
    highs/mip/HighsLpAggregator.cpp
    highs/mip/HighsLpRelaxation.cpp
    highs/mip/HighsMipAnalysis.cpp
    highs/mip/HighsMipSolver.cpp
    highs/mip/HighsMipSolverData.cpp
    highs/mip/HighsModkSeparator.cpp
    highs/mip/HighsNodeQueue.cpp
    highs/mip/HighsObjectiveFunction.cpp
    highs/mip/HighsPathSeparator.cpp
    highs/mip/HighsPrimalHeuristics.cpp
    highs/mip/HighsPseudocost.cpp
    highs/mip/HighsRedcostFixing.cpp
    highs/mip/HighsSearch.cpp
    highs/mip/HighsSeparation.cpp
    highs/mip/HighsSeparator.cpp
    highs/mip/HighsTableauSeparator.cpp
    highs/mip/HighsTransformedLp.cpp
    highs/model/HighsHessian.cpp
    highs/model/HighsHessianUtils.cpp
    highs/model/HighsModel.cpp
    highs/parallel/HighsTaskExecutor.cpp
    highs/pdlp/CupdlpWrapper.cpp
    highs/presolve/HighsPostsolveStack.cpp
    highs/presolve/HighsSymmetry.cpp
    highs/presolve/HPresolve.cpp
    highs/presolve/HPresolveAnalysis.cpp
    highs/presolve/ICrash.cpp
    highs/presolve/ICrashUtil.cpp
    highs/presolve/ICrashX.cpp
    highs/presolve/PresolveComponent.cpp
    highs/qpsolver/a_asm.cpp
    highs/qpsolver/a_quass.cpp
    highs/qpsolver/basis.cpp
    highs/qpsolver/perturbation.cpp
    highs/qpsolver/quass.cpp
    highs/qpsolver/ratiotest.cpp
    highs/qpsolver/scaling.cpp
    highs/simplex/HEkk.cpp
    highs/simplex/HEkkControl.cpp
    highs/simplex/HEkkDebug.cpp
    highs/simplex/HEkkDual.cpp
    highs/simplex/HEkkDualMulti.cpp
    highs/simplex/HEkkDualRHS.cpp
    highs/simplex/HEkkDualRow.cpp
    highs/simplex/HEkkInterface.cpp
    highs/simplex/HEkkPrimal.cpp
    highs/simplex/HighsSimplexAnalysis.cpp
    highs/simplex/HSimplex.cpp
    highs/simplex/HSimplexDebug.cpp
    highs/simplex/HSimplexNla.cpp
    highs/simplex/HSimplexNlaDebug.cpp
    highs/simplex/HSimplexNlaFreeze.cpp
    highs/simplex/HSimplexNlaProductForm.cpp
    highs/simplex/HSimplexReport.cpp
    highs/test_kkt/KktCh2.cpp
    highs/test_kkt/DevKkt.cpp
    highs/util/HFactor.cpp
    highs/util/HFactorDebug.cpp
    highs/util/HFactorExtend.cpp
    highs/util/HFactorRefactor.cpp
    highs/util/HFactorUtils.cpp
    highs/util/HighsHash.cpp
    highs/util/HighsLinearSumBounds.cpp
    highs/util/HighsMatrixPic.cpp
    highs/util/HighsMatrixUtils.cpp
    highs/util/HighsSort.cpp
    highs/util/HighsSparseMatrix.cpp
    highs/util/HighsUtils.cpp
    highs/util/HSet.cpp
    highs/util/HVectorBase.cpp
    highs/util/stringutil.cpp)

set(highs_headers_python
    extern/filereaderlp/builder.hpp
    extern/filereaderlp/def.hpp
    extern/filereaderlp/model.hpp
    extern/filereaderlp/reader.hpp
    extern/pdqsort/pdqsort.h
    highs/interfaces/highs_c_api.h
    highs/io/Filereader.h
    highs/io/FilereaderEms.h
    highs/io/FilereaderLp.h
    highs/io/FilereaderMps.h
    highs/io/HighsIO.h
    highs/io/HMpsFF.h
    highs/io/HMPSIO.h
    highs/io/LoadOptions.h
    highs/ipm/IpxSolution.h
    highs/ipm/IpxWrapper.h
    highs/lp_data/HConst.h
    highs/lp_data/HighsAnalysis.h
    highs/lp_data/HighsCallback.h
    highs/lp_data/HighsCallbackStruct.h
    highs/lp_data/HighsDebug.h
    highs/lp_data/HighsIis.h
    highs/lp_data/HighsInfo.h
    highs/lp_data/HighsInfoDebug.h
    highs/lp_data/HighsLp.h
    highs/lp_data/HighsLpSolverObject.h
    highs/lp_data/HighsLpUtils.h
    highs/lp_data/HighsModelUtils.h
    highs/lp_data/HighsOptions.h
    highs/lp_data/HighsRanging.h
    highs/lp_data/HighsSolution.h
    highs/lp_data/HighsSolutionDebug.h
    highs/lp_data/HighsSolve.h
    highs/lp_data/HighsStatus.h
    highs/lp_data/HStruct.h
    highs/mip/feasibilityjump.hh
    highs/mip/HighsCliqueTable.h
    highs/mip/HighsConflictPool.h
    highs/mip/HighsCutGeneration.h
    highs/mip/HighsCutPool.h
    highs/mip/HighsDebugSol.h
    highs/mip/HighsDomain.h
    highs/mip/HighsDomainChange.h
    highs/mip/HighsDynamicRowMatrix.h
    highs/mip/HighsGFkSolve.h
    highs/mip/HighsImplications.h
    highs/mip/HighsLpAggregator.h
    highs/mip/HighsLpRelaxation.h
    highs/mip/HighsMipAnalysis.h
    highs/mip/HighsMipSolver.h
    highs/mip/HighsMipSolverData.h
    highs/mip/HighsModkSeparator.h
    highs/mip/HighsNodeQueue.h
    highs/mip/HighsObjectiveFunction.h
    highs/mip/HighsPathSeparator.h
    highs/mip/HighsPrimalHeuristics.h
    highs/mip/HighsPseudocost.h
    highs/mip/HighsRedcostFixing.h
    highs/mip/HighsSearch.h
    highs/mip/HighsSeparation.h
    highs/mip/HighsSeparator.h
    highs/mip/HighsTableauSeparator.h
    highs/mip/HighsTransformedLp.h
    highs/mip/MipTimer.h
    highs/model/HighsHessian.h
    highs/model/HighsHessianUtils.h
    highs/model/HighsModel.h
    highs/parallel/HighsBinarySemaphore.h
    highs/parallel/HighsCacheAlign.h
    highs/parallel/HighsCombinable.h
    highs/parallel/HighsMutex.h
    highs/parallel/HighsParallel.h
    highs/parallel/HighsRaceTimer.h
    highs/parallel/HighsSchedulerConstants.h
    highs/parallel/HighsSpinMutex.h
    highs/parallel/HighsSplitDeque.h
    highs/parallel/HighsTask.h
    highs/parallel/HighsTaskExecutor.h
    highs/pdlp/CupdlpWrapper.h
    highs/presolve/HighsPostsolveStack.h
    highs/presolve/HighsSymmetry.h
    highs/presolve/HPresolve.h
    highs/presolve/HPresolveAnalysis.h
    highs/presolve/ICrash.h
    highs/presolve/ICrashUtil.h
    highs/presolve/ICrashX.h
    highs/presolve/PresolveComponent.h
    highs/qpsolver/a_asm.hpp
    highs/qpsolver/a_quass.hpp
    highs/qpsolver/basis.hpp
    highs/qpsolver/crashsolution.hpp
    highs/qpsolver/dantzigpricing.hpp
    highs/qpsolver/devexpricing.hpp
    highs/qpsolver/eventhandler.hpp
    highs/qpsolver/factor.hpp
    highs/qpsolver/feasibility_bounded.hpp
    highs/qpsolver/feasibility_highs.hpp
    highs/qpsolver/gradient.hpp
    highs/qpsolver/instance.hpp
    highs/qpsolver/matrix.hpp
    highs/qpsolver/perturbation.hpp
    highs/qpsolver/pricing.hpp
    highs/qpsolver/qpconst.hpp
    highs/qpsolver/qpvector.hpp
    highs/qpsolver/quass.hpp
    highs/qpsolver/ratiotest.hpp
    highs/qpsolver/runtime.hpp
    highs/qpsolver/scaling.hpp
    highs/qpsolver/settings.hpp
    highs/qpsolver/snippets.hpp
    highs/qpsolver/statistics.hpp
    highs/qpsolver/steepestedgepricing.hpp
    highs/simplex/HApp.h
    highs/simplex/HEkk.h
    highs/simplex/HEkkDual.h
    highs/simplex/HEkkDualRHS.h
    highs/simplex/HEkkDualRow.h
    highs/simplex/HEkkPrimal.h
    highs/simplex/HighsSimplexAnalysis.h
    highs/simplex/HSimplex.h
    highs/simplex/HSimplexDebug.h
    highs/simplex/HSimplexNla.h
    highs/simplex/HSimplexReport.h
    highs/simplex/SimplexConst.h
    highs/simplex/SimplexStruct.h
    highs/simplex/SimplexTimer.h
    highs/test_kkt/DevKkt.h
    highs/test_kkt/KktCh2.h
    highs/util/FactorTimer.h
    highs/util/HFactor.h
    highs/util/HFactorConst.h
    highs/util/HFactorDebug.h
    highs/util/HighsCDouble.h
    highs/util/HighsComponent.h
    highs/util/HighsDataStack.h
    highs/util/HighsDisjointSets.h
    highs/util/HighsHash.h
    highs/util/HighsHashTree.h
    highs/util/HighsInt.h
    highs/util/HighsIntegers.h
    highs/util/HighsLinearSumBounds.h
    highs/util/HighsMatrixPic.h
    highs/util/HighsMatrixSlice.h
    highs/util/HighsMatrixUtils.h
    highs/util/HighsMemoryAllocation.h
    highs/util/HighsRandom.h
    highs/util/HighsRbTree.h
    highs/util/HighsSort.h
    highs/util/HighsSparseMatrix.h
    highs/util/HighsSparseVectorSum.h
    highs/util/HighsSplay.h
    highs/util/HighsTimer.h
    highs/util/HighsUtils.h
    highs/util/HSet.h
    highs/util/HVector.h
    highs/util/HVectorBase.h
    highs/util/stringutil.h
    highs/Highs.h
  )