# Support code that may be used in debian/rules
# Alastair McKinstry <mckinstry@debian.org>
# 2025-06-13

include /usr/share/dpkg/buildflags.mk
include /usr/share/dpkg/architecture.mk

# WARNING: THIS CODE IS EXPERIMENTAL AND IN HIGH FLUX

# This will set:
#	FC_DEFAULT : the default compiler flavor
#	FC_OPTIONAL : a space seperated list of compiler flavors present except FC_DEFAULT

# FC_DEFAULT is /etc/alternatives/f95 unless FC is specified in the environment

# FC flavors: shortnames for Fortran compilers, currently in Trixie:
#  gfortran flang flangext lfortran flang18 flangext18 flang19 flangext19

# FC=f77 as a default in Make. The fortran-support.mk  sets FC_DEFAULT as a proper compiler flavor
# but get_fmoddir(f77) not properly defined, so don't call with FC=f77
# as a hack, f77 is presumed to be gfortran



ifeq ($(origin F77),default)
  F77:=$(shell basename $(shell readlink /etc/alternatives/f77))
endif
ifeq ($(origin FC),environment)
  FC_DEFAULT:=$(FC)
  # FC_DEFAULT:=$(call get_fc_flavor,$(FC))
endif
ifeq ($(origin FC),default)
  FC_DEFAULT:=$(FC)
  #FC_DEFAULT:=$(call get_fc_flavor,$(shell basename $(shell readlink /etc/alternatives/f95)))
endif

FC_COMPILERS:= $(if $(wildcard /usr/bin/gfortran-13), gfortran13 , ) \
		   $(if $(wildcard /usr/bin/gfortran-14), gfortran14 , )  \
		   $(if $(wildcard /usr/bin/gfortran-15), gfortran15 , )  \
		   $(if $(wildcard /usr/bin/flang-new-17), flang17 , )  \
		   $(if $(wildcard /usr/bin/flang-new-18), flang18 , )  \
		   $(if $(wildcard /usr/bin/flang-new-19), flang19 , )  \
		   $(if $(wildcard /usr/bin/flang-new-20), flang20 , )  \
		   $(if $(wildcard /usr/bin/flang-17), flang17 , )  \
		   $(if $(wildcard /usr/bin/flang-18), flang18 , )  \
		   $(if $(wildcard /usr/bin/flang-19), flang19 , )  \
		   $(if $(wildcard /usr/bin/flang-20), flang20 , )  \
		   $(if $(wildcard /usr/bin/flang-to-external-fc-17), flangext17 , )  \
		   $(if $(wildcard /usr/bin/flang-to-external-fc-18), flangext18 , )  \
		   $(if $(wildcard /usr/bin/lfortran), lfortran, )  

FC_OPTIONAL:=$(filter-out $(FC_DEFAULT),$(shell echo $(FC_COMPILERS) | sed -e 's% %\n%g' | sort | uniq | xargs echo))

# Functions: take flavor as parameter

# get_fmoddir:
#   return the Module(s)directory usable by this flavour


# TODO: This should strip arch from eg aarch64-linux-gnu-gfortran-14
_ARCH:=$(shell echo $(FC)| sed -r 's%(.*)-(.*)%\1 %' )
_SUFF:=$(shell echo $(FC)| sed -r 's%(.*)-(.*)%\2 %' )
ifeq ($(_ARCH),$(_SUFF))
  _ARCH:=${DEB_HOST_MULTIARCH}
else
  FC:=$(_SUFF)
endif
fort_root = /usr/lib/$(strip $(_ARCH))/fortran

# Currently gfortran defaults to gfortran-14, flang to flang-19

# Install in this directory
get_fmoddir = $(strip \
		  $(if $(filter $1, f77), $(fort_root)/gfortran-mod-16, \
		  $(if $(filter $1,gfortran), $(fort_root)/gfortran-mod-16, \
		  $(if $(filter $1,gfortran14), $(fort_root)/gfortran-mod-15, \
		  $(if $(filter $1,gfortran15), $(fort_root)/gfortran-mod-16, \
		  $(if $(filter $1, flang), $(fort_root)/flang-mod-19, \
		  $(if $(filter $1, flang17), $(fort_root)/flang-mod-17, \
		  $(if $(filter $1, flang18), $(fort_root)/flang-mod-18, \
		  $(if $(filter $1, flang19), $(fort_root)/flang-mod-19, \
		  $(if $(filter $1, flang20), $(fort_root)/flang-mod-20, \
		  $(if $(filter $1, flangext), $(fort_root)/flangext-mod-18, \
		  $(if $(filter $1, flangext17), $(fort_root)/flangext-mod-17, \
		  $(if $(filter $1, flangext18), $(fort_root)/flangext-mod-18, \
		  $(if $(filter $1, lfortran), $(fort_root)/lfortran-mod-0, \
					   $(fort_root)/$1 ))))))))))))))

# Compatible modules for include search. Directories may not be present
get_fmoddirs = $(if $(filter $1,gfortran),  -I$(call fort_root,$1)/gfortran-mod-15 -I$(call fort_root,$1)/flangext-mod-15, \
			   $(if $(filter $1,f77), -I$(call fort_root,$1)/gfortran-mod-15 -I$(call fort_root,$1)/flangext-mod-15, \
			   $(if $(filter $1,gfortran14), -I$(call fort_root,$1)/gfortran-mod-15 -I$(call fort_root,$1)/flangext-mod-15, \
			   $(if $(filter $1,gfortran15), -I$(call fort_root,$1)/gfortran-mod-15 -I$(call fort_root,$1)/flangext-mod-16, \
		   $(if $(filter $1, flang),	-I$(call fort_root,$1)/flang-mod-19, \
		   $(if $(filter $1, flang17),	-I$(call fort_root,$1)/flang-mod-17, \
		   $(if $(filter $1, flang18),	-I$(call fort_root,$1)/flang-mod-18, \
		   $(if $(filter $1, flang19),	-I$(call fort_root,$1)/flang-mod-19, \
		   $(if $(filter $1, flang20),	-I$(call fort_root,$1)/flang-mod-20, \
		   $(if $(filter $1, flangext), -I$(call fort_root,$1)/flangext-mod-18 -I$(call fort_root,$1)/gfortran-mod-15, \
		   $(if $(filter $1, flangext18), -I$(call fort_root,$1)/flangext-mod-15 -I$(call fort_root,$1)/gfortran-mod-15, \
		   $(if $(filter $1, lfortran), -I$(call fort_root,$1)/lfortran-mod-0, \
						-I$(call fort_root,$1)/$1 ))))))))))))

# get_fc_exe
#   Compiler name, suitable for -DCMAKE_Fortran_COMPILER=$(call get_fc_exe,XXX)

get_fc_exe = $(strip \
		 $(if $(filter $1,gfortran), /usr/bin/gfortran-14, \
		 $(if $(filter $1,gfortran15), /usr/bin/gfortran-15, \
		 $(if $(filter $1,gfortran14), /usr/bin/gfortran-14, \
		 $(if $(filter $1,gfortran13), /usr/bin/gfortran-13, \
		 $(if $(filter $1,flang),	/usr/bin/flang-new-17, \
		 $(if $(filter $1,flang18),	/usr/bin/flang-new-18, \
		 $(if $(filter $1,flang19),	/usr/bin/flang-new-19, \
		 $(if $(filter $1,flang20),	/usr/bin/flang-new-20, \
		 $(if $(filter $1,flangext), /usr/bin/flang-to-external-fc-17, \
		 $(if $(filter $1,flangext18), /usr/bin/flang-to-external-fc-18, \
		 $(if $(filter $1,lfortran), /usr/bin/lfortran, \
					 /usr/bin/$(FC_DEFAULT)  ))))))))))))

# TODO  get_fc_flavor = $(if $(filter $(shell $1,/usr/bin//usr/bin/gfortran), gfortran, FALSE)

_to_label=$(shell echo  "$1" | sed -e 's/\(.*\)/\U\1/' -e 's/\-//')
_to_vendor=$(shell echo  "$1" | sed -e 's/[0-9\-].*//' )

get_flibdir=$(if $(filter $1,f77), $(call fort_root,$1)/fortran/gfortran, \
		$(call fort_root,$1)/fortran/$(strip $(call _to_vendor, $1)))


# Compatible directories for library search. Directories may not be present
get_flibdirs = $(if $(filter $1,gfortran), -L$(call fort_root,$1)/gfortran -L$(call fort_root,$1)/flangext, \
		   $(if $(filter $1,f77),	 -L$(call fort_root,$1)/gfortran -L$(call fort_root,$1)/flangext, \
		   $(if $(filter $1,flang),	-L$(call fort_root,$1)/flang, \
		   $(if $(filter $1,flang18),  -L$(call fort_root,$1)/flang, \
		   $(if $(filter $1,flang19),  -L$(call fort_root,$1)/flang, \
		   $(if $(filter $1,flang20),  -L$(call fort_root,$1)/flang, \
		   $(if $(filter $1,flangext), -L$(call fort_root,$1)/flangext -L$(call fort_root,$1)/gfortran, \
		   $(if $(filter $1,flangext18), -L$(call fort_root,$1)/flangext18 -L$(call fort_root,$1)/gfortran, \
		   $(if $(filter $1,lfortran), -L$(call fort_root,$1)/lfortran, \
					   -L$(call fort_root,$1)/$1 )))))))))

get_fc_vendor = $(strip \
		   $(if $(filter $1,f77),	 gfortran , \
		   $(if $(filter $1,gfortran), gfortran ,\
		   $(if $(filter $1,gfortran13), gfortran ,\
		   $(if $(filter $1,gfortran14), gfortran ,\
		   $(if $(filter $1,gfortran15), gfortran ,\
		   $(if $(filter $1,flang),  flang ,\
		   $(if $(filter $1,flang17),  flang ,\
		   $(if $(filter $1,flang18),  flang ,\
		   $(if $(filter $1,flang19),  flang ,\
		   $(if $(filter $1,flang20),  flang ,\
		   $(if $(filter $1,flangext18), gfortran, \
		   $(if $(filter $1,lfortran), lfortran )))))))))))))




# Compiler-specific fixes to FCFLAGS


# See #957692

FCLAGS_ADD_GFORTRAN10:= -fallow-invalid-boz -fallow-argument-mismatch
FCLAGS_ADD_GFORTRAN11:= -fallow-invalid-boz -fallow-argument-mismatch
FCLAGS_ADD_GFORTRAN12:= -fallow-invalid-boz -fallow-argument-mismatch
FCLAGS_ADD_GFORTRAN13:= -fallow-invalid-boz -fallow-argument-mismatch
FCLAGS_ADD_GFORTRAN14:= -fallow-invalid-boz -fallow-argument-mismatch
FCLAGS_ADD_GFORTRAN15:= -fallow-invalid-boz -fallow-argument-mismatch


FCFLAGS_STRIP_FLANG7:= -g 
FCFLAGS_STRIP_FLANG18:= -mbranch-protection=standard -fstack-protector-strong -fstack-clash-protection -ffile-prefix-map%
FCFLAGS_STRIP_FLANG19:= -mbranch-protection=standard -fstack-protector-strong -fstack-clash-protection -ffile-prefix-map%
FCFLAGS_STRIP_FLANG20:= -mbranch-protection=standard -fstack-protector-strong -fstack-clash-protection -ffile-prefix-map%

FCFLAGS_ADD_gfortran:= $(FCLAGS_ADD_GFORTRAN13)
FCFLAGS_ADD_flangext:= $(FCLAGS_ADD_GFORTRAN13)
FCFLAGS_STRIP_flang:= $(FCFLAGS_STRIP_FLANG17)

define get_fcflags =  
  $(filter-out $(FCFLAGS_STRIP_$(call _to_label,$1)),$(FCFLAGS)) $(FCFLAGS_ADD_$(call _to_label,$1))
endef

### Support code for configure/build.
### Assuming dh_X_fortran_TEMPLATE is defined, use that to build / configure
### Must succeed on FC_DEFAULT, may fail on FC_OPTIONAL compilers
### (for capturing details in logs )

# Potentially add others if $FC is set (eg ifx, Arm)

# TODO: improve on "-f debian/rules"
define dh_fortran_RECURSE =
 dh_$(1)_fortran_$(2)_nofail:
	@echo DEBUGF RECURSE into dh_$(1)_fortran_$(2)
	@($(MAKE) -f debian/rules dh_$(1)_fortran_$(2) || echo " FAILURE IGNORED")
	@echo DEBUGF LEAVING dh_$(1)_fortran_$(2)_nofail
endef

# This will iterate over targets and recursively call make but to always succeed
define foreach_fc_dot =
  $(foreach f, $(FC_DEFAULT) $(FC_OPTIONAL), $(eval $(call dh_$(1)_fortran_TEMPLATE,$(f))))
  $(foreach f, $(FC_OPTIONAL) , $(eval $(call dh_fortran_RECURSE,$(1),$(f))))
endef

define foreach_fc_execute_before =
  $(eval $(call foreach_fc_dot,$(1)))
  execute_before_dh_auto_$(1): $(foreach FC_FLAVOR, $(FC_DEFAULT), dh_$(1)_fortran_$(FC_FLAVOR)) $(foreach FC_FLAVOR, $(FC_OPTIONAL), dh_$(1)_fortran_$(FC_FLAVOR)_nofail)
endef

define foreach_fc_execute_after =
  $(eval $(call foreach_fc_dot,$(1)))
  execute_after_dh_auto_$(1): $(foreach FC_FLAVOR, $(FC_DEFAULT), dh_$(1)_fortran_$(FC_FLAVOR)) $(foreach FC_FLAVOR, $(FC_OPTIONAL), dh_$(1)_fortran_$(FC_FLAVOR)_nofail)
endef

define dh_clean_fortran_TEMPLATE =
  dh_clean_fortran_$(1):
	rm -rf $(BUILDDIR)-$(1) $(DESTDIR)-$(1)
endef
# $(eval $(call foreach_fc_execute_before,clean))

define dh_build_fortran_TEMPLATE =
  dh_build_fortran_$(1):
		dh_auto_build --builddirectory=${BUILDDIR}-$(1)
endef
# $(eval $(call foreach_fc_execute_before,build))

# Default. TODO: This works for cmake. Produce other version?
define dh_configure_fortran_TEMPLATE =
  dh_configure_fortran_$(1):
				dh_auto_configure --builddirectory=debian/build-$(1)  -- \
						${BUILD_FLAGS} -DCMAKE_Fortran_COMPILER=$(call get_fc_exe, $(1)) \
								-DCMAKE_Fortran_FLAGS="$(call get_fcflags,$(1))"
endef

define dh_test_fortran_TEMPLATE =
  dh_test_fortran_$(1):
ifeq (,$(filter nocheck,$(DEB_BUILD_OPTIONS)))
		(LD_LIBRARY_PATH=$(BUILDDIR)-$(1)/lib dh_auto_test --builddirectory=$(BUILDDIR)-$(1) || true)
endif
endef
