# Generated by Django 5.1.5 on 2025-02-03 22:55

import django.db.models.deletion
from django.db import migrations, models

import debusine.assets.models
import debusine.db.constraints


class Migration(migrations.Migration):

    dependencies = [
        ('db', '0122_create_default_task_configuration_collections'),
    ]

    operations = [
        migrations.AlterField(
            model_name='asset',
            name='category',
            field=models.CharField(
                choices=[
                    (
                        'debusine:cloud-provider-account',
                        'debusine:cloud-provider-account',
                    ),
                    ('debusine:signing-key', 'debusine:signing-key'),
                ],
                max_length=255,
            ),
        ),
        migrations.AlterField(
            model_name='asset',
            name='workspace',
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to='db.workspace',
            ),
        ),
        migrations.AddConstraint(
            model_name='asset',
            constraint=debusine.db.constraints.JsonDataUniqueConstraint(
                condition=models.Q(
                    (
                        'category',
                        debusine.assets.models.AssetCategory[
                            'CLOUD_PROVIDER_ACCOUNT'
                        ],
                    )
                ),
                fields=("data->>'name'",),
                name='db_asset_unique_cloud_provider_acct_name',
                nulls_distinct=False,
            ),
        ),
        migrations.AddConstraint(
            model_name='asset',
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        (
                            'category',
                            debusine.assets.models.AssetCategory['SIGNING_KEY'],
                        ),
                        _negated=True,
                    ),
                    ('workspace__isnull', False),
                    _connector='OR',
                ),
                name='db_asset_workspace_not_null',
            ),
        ),
    ]
