/*
 * TagLib C# bindings
 * by Clemens Koppensteiner
 *
 * This work is hereby released into the Public Domain. To view a copy of the
 * public domain dedication, visit
 * http://creativecommons.org/licenses/publicdomain/ or send a letter to
 * Creative Commons, 543 Howard Street, 5th Floor, San Francisco, California,
 * 94105, USA.
 */

using System;
using System.Runtime.InteropServices;

namespace TagLib
{
	public class Tag : Object
	{
		public Tag(IntPtr ptr) : base (ptr) {}
		
		string title;
		public string Title {
			get {
				if (title == null) {
					title = taglib_tag_title(ptr);
				}

				return title;
			}
			set {
				this.title = value;
				taglib_tag_set_title(ptr, title);
			} 
		}

		string artist;
		public string Artist {
			get {
				if (artist == null) {
					artist = taglib_tag_artist(ptr);
				}

				return artist;
			}
			set {
				this.artist = value;
				taglib_tag_set_artist(ptr, artist);
			} 
		}

		string album;
		public string Album {
			get {
				if (album == null) {
					album = taglib_tag_album(ptr);
				}

				return album;
			}
			set {
				this.album = value;
				taglib_tag_set_album(ptr, album);
			} 
		}
		
		string comment;
		public string Comment {
			get {
				if (comment == null) {
					comment = taglib_tag_comment(ptr);
				}

				return comment;
			}
			set {
				this.comment = value;
				taglib_tag_set_comment(ptr, comment);
			} 
		}
		
		string genre;
		public string Genre {
			get {
				if (genre == null) {
					genre = taglib_tag_genre(ptr);
				}

				return genre;
			}
			set {
				this.genre = value;
				taglib_tag_set_genre(ptr, genre);
			} 
		}
		
		uint year = 0;
		public uint Year {
			get {
				if (year == 0) {
					year = taglib_tag_year(ptr);
				}

				return year;
			}
			set {
				this.year = value;
				taglib_tag_set_year(ptr, year);
			} 
		}
		
		uint track = 0;
		public uint Track {
			get {
				if (track == 0) {
					track = taglib_tag_track(ptr);
				}

				return track;
			}
			set {
				this.track = value;
				taglib_tag_set_track(ptr, track);
			} 
		}
		
		[DllImport("libtag_c")]
		static extern string taglib_tag_title(IntPtr tag);
	 
		[DllImport("libtag_c")]
		static extern string taglib_tag_artist(IntPtr tag);
		
		[DllImport("libtag_c")]
		static extern string taglib_tag_album(IntPtr tag);
		
		[DllImport("libtag_c")]
		static extern string taglib_tag_comment(IntPtr tag);
		
		[DllImport("libtag_c")]
		static extern string taglib_tag_genre(IntPtr tag);
		
		[DllImport("libtag_c")]
		static extern uint taglib_tag_year(IntPtr tag);
		
		[DllImport("libtag_c")]
		static extern uint taglib_tag_track(IntPtr tag);
		
		[DllImport("libtag_c")]
		static extern void taglib_tag_set_title(IntPtr tag, string title);
		
		[DllImport("libtag_c")]
		static extern void taglib_tag_set_artist(IntPtr tag, string artist);
		
		[DllImport("libtag_c")]
		static extern void taglib_tag_set_album(IntPtr tag, string album);
		
		[DllImport("libtag_c")]
		static extern void taglib_tag_set_comment(IntPtr tag, string comment);
		
		[DllImport("libtag_c")]
		static extern void taglib_tag_set_genre(IntPtr tag, string genre);
		
		[DllImport("libtag_c")]
		static extern void taglib_tag_set_year(IntPtr tag, uint year);
		
		[DllImport("libtag_c")]
		static extern void taglib_tag_set_track(IntPtr tag, uint track);
	}
}
