set(csProjectFile "${RunCMake_TEST_BINARY_DIR}/foo.csproj")
if(NOT EXISTS "${csProjectFile}")
  set(RunCMake_TEST_FAILED "Project file ${csProjectFile} does not exist.")
  return()
endif()


set(inNode1 FALSE)
set(foundNode1 FALSE)
set(foundCopyDirective1 FALSE)

set(inNode2 FALSE)
set(foundNode2 FALSE)
set(foundCopyDirective2 FALSE)

set(foundNode3 FALSE)

file(STRINGS "${csProjectFile}" lines)

foreach(line IN LISTS lines)
    if( inNode1 )
      if(line MATCHES " *<CopyToOutputDirectory>PreserveNewest</CopyToOutputDirectory> *$")
        set(foundCopyDirective1 TRUE)
      elseif( line MATCHES " *</Content> *$")
        set(inNode1 FALSE)
      endif()
    elseif( inNode2 )
      if(line MATCHES " *<CopyToOutputDirectory>Always</CopyToOutputDirectory> *$")
        set(foundCopyDirective2 TRUE)
      elseif( line MATCHES " *</Content> *$")
        set(inNode2 FALSE)
      endif()
    elseif(line MATCHES "^ *<Content *Include *= *\".*content1\\.txt\"> *")
      set(foundNode1 TRUE)
      set(inNode1 TRUE)
    elseif(line MATCHES "^ *<Content *Include *= *\".*content2\\.txt\"> *")
      set(foundNode2 TRUE)
      set(inNode2 TRUE)
    elseif(line MATCHES "^ *<None *Include *= *\".*content3\\.txt\"> *")
      set(foundNode3 TRUE)
    endif()
endforeach()

if(NOT foundNode1)
  set(RunCMake_TEST_FAILED "Did not find <Content> item content1.txt.")
  return()
endif()

if(NOT foundCopyDirective1)
  set(RunCMake_TEST_FAILED "Did not find PreserveNewest for <Content> item content1.txt.")
  return()
endif()

if(NOT foundNode2)
  set(RunCMake_TEST_FAILED "Did not find <Content> item content2.txt.")
  return()
endif()

if(NOT foundCopyDirective2)
  set(RunCMake_TEST_FAILED "Did not find Always for <Content> item content2.txt.")
  return()
endif()

if(NOT foundNode3)
  set(RunCMake_TEST_FAILED "Did not find <None> item content3.txt.")
  return()
endif()
